/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.permission;

import io.netty.channel.Channel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Optional;
import org.apache.dubbo.qos.api.CommandContext;
import org.apache.dubbo.qos.api.PermissionLevel;
import org.apache.dubbo.qos.api.QosConfiguration;
import org.apache.dubbo.qos.permission.PermissionChecker;

public class DefaultAnonymousAccessPermissionChecker
implements PermissionChecker {
    public static final DefaultAnonymousAccessPermissionChecker INSTANCE = new DefaultAnonymousAccessPermissionChecker();

    @Override
    public boolean access(CommandContext commandContext, PermissionLevel defaultCmdRequiredPermissionLevel) {
        InetAddress inetAddress = Optional.ofNullable(commandContext.getRemote()).map(Channel::remoteAddress).map(InetSocketAddress.class::cast).map(InetSocketAddress::getAddress).orElse(null);
        QosConfiguration qosConfiguration = commandContext.getQosConfiguration();
        PermissionLevel currentLevel = qosConfiguration.getAnonymousAccessPermissionLevel();
        if (inetAddress != null && inetAddress.isLoopbackAddress()) {
            currentLevel = PermissionLevel.PRIVATE;
        } else if (inetAddress != null && qosConfiguration.getAcceptForeignIpWhitelistPredicate().test(inetAddress.getHostAddress())) {
            currentLevel = PermissionLevel.PROTECTED;
        }
        return currentLevel.getLevel() >= defaultCmdRequiredPermissionLevel.getLevel();
    }
}

