/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.command.impl;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.utils.ArrayUtils;
import org.apache.dubbo.qos.api.BaseCommand;
import org.apache.dubbo.qos.api.Cmd;
import org.apache.dubbo.qos.api.CommandContext;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;

@Cmd(name="publishMetadata", summary="update service metadata and service instance", example={"publishMetadata", "publishMetadata 5"})
public class PublishMetadata
implements BaseCommand {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(PublishMetadata.class);
    private final FrameworkModel frameworkModel;

    public PublishMetadata(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    public String execute(CommandContext commandContext, String[] args) {
        logger.info("received publishMetadata command.");
        StringBuilder stringBuilder = new StringBuilder();
        List applicationModels = this.frameworkModel.getApplicationModels();
        for (ApplicationModel applicationModel : applicationModels) {
            if (ArrayUtils.isEmpty((Object[])args)) {
                ServiceInstanceMetadataUtils.refreshMetadataAndInstance((ApplicationModel)applicationModel);
                stringBuilder.append("publish metadata succeeded. App:").append(applicationModel.getApplicationName()).append("\n");
                continue;
            }
            try {
                int delay = Integer.parseInt(args[0]);
                FrameworkExecutorRepository frameworkExecutorRepository = (FrameworkExecutorRepository)applicationModel.getFrameworkModel().getBeanFactory().getBean(FrameworkExecutorRepository.class);
                frameworkExecutorRepository.nextScheduledExecutor().schedule(() -> ServiceInstanceMetadataUtils.refreshMetadataAndInstance((ApplicationModel)applicationModel), (long)delay, TimeUnit.SECONDS);
            }
            catch (NumberFormatException e) {
                logger.error("5-17", "", "", "Wrong delay param", (Throwable)e);
                return "publishMetadata failed! Wrong delay param!";
            }
            stringBuilder.append("publish task submitted, will publish in ").append(args[0]).append(" seconds. App:").append(applicationModel.getApplicationName()).append("\n");
        }
        return stringBuilder.toString();
    }
}

