/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.pu;

import io.netty.util.CharsetUtil;
import org.apache.dubbo.qos.api.BaseCommand;
import org.apache.dubbo.qos.api.CommandContext;
import org.apache.dubbo.qos.command.decoder.TelnetCommandDecoder;
import org.apache.dubbo.remoting.api.ProtocolDetector;
import org.apache.dubbo.remoting.buffer.ChannelBuffer;
import org.apache.dubbo.remoting.buffer.ChannelBuffers;
import org.apache.dubbo.remoting.buffer.HeapChannelBuffer;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class TelnetDetector
implements ProtocolDetector {
    private final FrameworkModel frameworkModel;
    private final int MaxSize = 2048;
    private final ChannelBuffer AytPreface = new HeapChannelBuffer(new byte[]{-1, -10});

    public TelnetDetector(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    public ProtocolDetector.Result detect(ChannelBuffer in) {
        if (in.readableBytes() >= 2048) {
            return ProtocolDetector.Result.UNRECOGNIZED;
        }
        ProtocolDetector.Result resCommand = this.commandDetect(in);
        if (resCommand.equals((Object)ProtocolDetector.Result.RECOGNIZED)) {
            return resCommand;
        }
        ProtocolDetector.Result resAyt = this.telnetAytDetect(in);
        if (resAyt.equals((Object)ProtocolDetector.Result.RECOGNIZED)) {
            return resAyt;
        }
        if (resAyt.equals((Object)ProtocolDetector.Result.UNRECOGNIZED) && resCommand.equals((Object)ProtocolDetector.Result.UNRECOGNIZED)) {
            return ProtocolDetector.Result.UNRECOGNIZED;
        }
        return ProtocolDetector.Result.NEED_MORE_DATA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProtocolDetector.Result commandDetect(ChannelBuffer in) {
        byte[] backBytes;
        ChannelBuffer back = in.copy();
        try {
            backBytes = new byte[back.readableBytes()];
            back.getBytes(back.readerIndex(), backBytes);
        }
        finally {
            back.release();
        }
        String s = new String(backBytes, CharsetUtil.UTF_8);
        s = s.trim();
        CommandContext commandContext = TelnetCommandDecoder.decode(s);
        if (this.frameworkModel.getExtensionLoader(BaseCommand.class).hasExtension(commandContext.getCommandName())) {
            return ProtocolDetector.Result.RECOGNIZED;
        }
        return ProtocolDetector.Result.UNRECOGNIZED;
    }

    private ProtocolDetector.Result telnetAytDetect(ChannelBuffer in) {
        int prefaceLen = this.AytPreface.readableBytes();
        int bytesRead = Math.min(in.readableBytes(), prefaceLen);
        if (bytesRead == 0 || !ChannelBuffers.prefixEquals((ChannelBuffer)in, (ChannelBuffer)this.AytPreface, (int)bytesRead)) {
            return ProtocolDetector.Result.UNRECOGNIZED;
        }
        if (bytesRead == prefaceLen) {
            in.readBytes(this.AytPreface.readableBytes());
            in.markReaderIndex();
            return ProtocolDetector.Result.RECOGNIZED;
        }
        return ProtocolDetector.Result.NEED_MORE_DATA;
    }
}

