/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.qos.protocol;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.qos.api.PermissionLevel;
import org.apache.dubbo.qos.server.Server;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;

@Activate(order=200)
public class QosProtocolWrapper
implements Protocol,
ScopeModelAware {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(QosProtocolWrapper.class);
    private final AtomicBoolean hasStarted = new AtomicBoolean(false);
    private final Protocol protocol;
    private FrameworkModel frameworkModel;

    public QosProtocolWrapper(Protocol protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException("protocol == null");
        }
        this.protocol = protocol;
    }

    public void setFrameworkModel(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    public int getDefaultPort() {
        return this.protocol.getDefaultPort();
    }

    public <T> Exporter<T> export(Invoker<T> invoker) throws RpcException {
        this.startQosServer(invoker.getUrl(), true);
        return this.protocol.export(invoker);
    }

    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        this.startQosServer(url, false);
        return this.protocol.refer(type, url);
    }

    public void destroy() {
        this.protocol.destroy();
        this.stopServer();
    }

    public List<ProtocolServer> getServers() {
        return this.protocol.getServers();
    }

    private void startQosServer(URL url, boolean isServer) throws RpcException {
        block7: {
            boolean qosCheck = url.getParameter("qos.check", false);
            try {
                if (!this.hasStarted.compareAndSet(false, true)) {
                    return;
                }
                boolean qosEnable = url.getParameter("qos.enable", true);
                if (!qosEnable) {
                    this.logger.info("qos won't be started because it is disabled. Please check dubbo.application.qos.enable is configured either in system property, dubbo.properties or XML/spring-boot configuration.");
                    return;
                }
                String host = url.getParameter("qos.host");
                int port = url.getParameter("qos.port", 22222);
                boolean acceptForeignIp = Boolean.parseBoolean(url.getParameter("qos.accept.foreign.ip", "false"));
                String acceptForeignIpWhitelist = url.getParameter("qos.accept.foreign.ip.whitelist", "");
                String anonymousAccessPermissionLevel = url.getParameter("qos.anonymous.access.permission.level", PermissionLevel.PUBLIC.name());
                String anonymousAllowCommands = url.getParameter("qos.anonymous.access.allow.commands", "");
                Server server = (Server)this.frameworkModel.getBeanFactory().getBean(Server.class);
                if (server.isStarted()) {
                    return;
                }
                server.setHost(host);
                server.setPort(port);
                server.setAcceptForeignIp(acceptForeignIp);
                server.setAcceptForeignIpWhitelist(acceptForeignIpWhitelist);
                server.setAnonymousAccessPermissionLevel(anonymousAccessPermissionLevel);
                server.setAnonymousAllowCommands(anonymousAllowCommands);
                server.start();
            }
            catch (Throwable throwable) {
                this.logger.warn("7-4", "", "", "Fail to start qos server: ", throwable);
                if (!qosCheck) break block7;
                try {
                    this.stopServer();
                }
                catch (Throwable stop) {
                    this.logger.warn("7-4", "", "", "Fail to stop qos server: ", stop);
                }
                if (!isServer) break block7;
                throw new RpcException(throwable);
            }
        }
    }

    void stopServer() {
        Server server;
        if (this.hasStarted.compareAndSet(true, false) && (server = (Server)this.frameworkModel.getBeanFactory().getBean(Server.class)).isStarted()) {
            server.stop();
        }
    }
}

