/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.infra.InfraAdapter;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.MetadataParamsFilter;
import org.apache.dubbo.metadata.WritableMetadataService;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstanceCustomizer;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ServiceInstanceMetadataCustomizer
implements ServiceInstanceCustomizer {
    @Override
    public void customize(ServiceInstance serviceInstance) {
        ExtensionLoader loader = ExtensionLoader.getExtensionLoader(MetadataParamsFilter.class);
        Set paramsFilters = loader.getSupportedExtensionInstances();
        WritableMetadataService localMetadataService = WritableMetadataService.getDefaultExtension();
        MetadataInfo metadataInfo = (MetadataInfo)localMetadataService.getMetadataInfos().values().iterator().next();
        MetadataInfo.ServiceInfo serviceInfo = (MetadataInfo.ServiceInfo)metadataInfo.getServices().values().iterator().next();
        HashMap allParams = new HashMap(serviceInfo.getUrl().getParameters());
        Set adapters = ExtensionLoader.getExtensionLoader(InfraAdapter.class).getSupportedExtensionInstances();
        if (CollectionUtils.isNotEmpty((Collection)adapters)) {
            HashMap<String, String> inputParameters = new HashMap<String, String>();
            inputParameters.put("application", ApplicationModel.getName());
            for (InfraAdapter adapter : adapters) {
                Map extraParameters = adapter.getExtraAttributes(inputParameters);
                if (!CollectionUtils.isNotEmptyMap((Map)extraParameters)) continue;
                extraParameters.forEach(allParams::putIfAbsent);
            }
        }
        if (CollectionUtils.isEmpty((Collection)paramsFilters)) {
            serviceInstance.getMetadata().putAll(allParams);
            return;
        }
        paramsFilters.forEach(filter -> {
            String[] included = filter.instanceParamsIncluded();
            if (included == null) {
                serviceInstance.getMetadata().putAll(allParams);
            } else {
                for (String p : included) {
                    if (allParams.get(p) == null) continue;
                    serviceInstance.getMetadata().put(p, (String)allParams.get(p));
                }
            }
        });
    }
}

