/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.compiler.support.ClassUtils;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metadata.MetadataService;

public class URLRevisionResolver {
    public static final String NO_REVISION = "N/A";

    public String resolve(Collection<String> urls) {
        if (CollectionUtils.isEmpty(urls)) {
            return NO_REVISION;
        }
        List<URL> urlsList = this.toURLsList(urls);
        SortedSet<String> methodSignatures = this.resolveMethodSignatures(urlsList);
        SortedSet<String> urlParameters = this.resolveURLParameters(urlsList);
        TreeSet<String> values = new TreeSet<String>(methodSignatures);
        values.addAll(urlParameters);
        return values.stream().map(this::hashCode).reduce(Long::sum).map(String::valueOf).orElse(NO_REVISION);
    }

    private List<URL> toURLsList(Collection<String> urls) {
        return urls.stream().map(URL::valueOf).filter(url -> this.isNotMetadataService(url.getServiceInterface())).collect(Collectors.toList());
    }

    private SortedSet<String> resolveMethodSignatures(List<URL> urls) {
        return urls.stream().map(URL::getServiceInterface).map(ClassUtils::forName).map(Class::getMethods).map(Arrays::asList).flatMap(Collection::stream).map(Object::toString).collect(TreeSet::new, Set::add, Set::addAll);
    }

    private SortedSet<String> resolveURLParameters(Collection<URL> urls) {
        return urls.stream().map(url -> url.removeParameter("pid")).map(url -> url.removeParameter("timestamp")).map(URL::toParameterString).collect(TreeSet::new, Set::add, Set::addAll);
    }

    private long hashCode(String value) {
        long h = 0L;
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            h = 31L * h + (long)chars[i];
        }
        return h;
    }

    private boolean isNotMetadataService(String serviceInterface) {
        return !MetadataService.class.getName().equals(serviceInterface);
    }
}

