/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.registry.client.ServiceInstance;

public class DefaultServiceInstance
implements ServiceInstance {
    private static final long serialVersionUID = 1149677083747278100L;
    private String id;
    private String serviceName;
    private String host;
    private Integer port;
    private boolean enabled;
    private boolean healthy;
    private Map<String, String> metadata = new HashMap<String, String>();

    public DefaultServiceInstance() {
    }

    public DefaultServiceInstance(String id, String serviceName, String host, Integer port) {
        if (port != null && port < 1) {
            throw new IllegalArgumentException("The port must be greater than zero!");
        }
        this.id = id;
        this.serviceName = serviceName;
        this.host = host;
        this.port = port;
        this.enabled = true;
        this.healthy = true;
    }

    public DefaultServiceInstance(String serviceName, String host, Integer port) {
        this(host + ":" + port, serviceName, host, port);
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isHealthy() {
        return this.healthy;
    }

    public void setHealthy(boolean healthy) {
        this.healthy = healthy;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultServiceInstance)) {
            return false;
        }
        DefaultServiceInstance that = (DefaultServiceInstance)o;
        return this.isEnabled() == that.isEnabled() && this.isHealthy() == that.isHealthy() && Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getServiceName(), that.getServiceName()) && Objects.equals(this.getHost(), that.getHost()) && Objects.equals(this.getPort(), that.getPort()) && Objects.equals(this.getMetadata(), that.getMetadata());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getId(), this.getServiceName(), this.getHost(), this.getPort(), this.isEnabled(), this.isHealthy(), this.getMetadata());
    }

    public String toString() {
        return "DefaultServiceInstance{id='" + this.id + '\'' + ", serviceName='" + this.serviceName + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", enabled=" + this.enabled + ", healthy=" + this.healthy + ", metadata=" + this.metadata + '}';
    }
}

