/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.client.DefaultServiceInstance;
import org.apache.dubbo.registry.client.ServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstanceCustomizer;
import org.apache.dubbo.registry.integration.InterfaceCompatibleRegistryProtocol;
import org.apache.dubbo.registry.support.RegistryManager;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ServiceInstanceMetadataUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceInstanceMetadataUtils.class);
    public static final String METADATA_SERVICE_PREFIX = "dubbo.metadata-service.";
    public static final String ENDPOINTS = "dubbo.endpoints";
    public static final String METADATA_SERVICE_URL_PARAMS_PROPERTY_NAME = "dubbo.metadata-service.url-params";
    public static final String METADATA_SERVICE_URLS_PROPERTY_NAME = "dubbo.metadata-service.urls";
    public static final String EXPORTED_SERVICES_REVISION_PROPERTY_NAME = "dubbo.metadata.revision";
    public static final String METADATA_STORAGE_TYPE_PROPERTY_NAME = "dubbo.metadata.storage-type";
    public static final String METADATA_CLUSTER_PROPERTY_NAME = "dubbo.metadata.cluster";
    public static final Gson gson = new Gson();

    public static String getMetadataServiceParameter(URL url) {
        if (url == null) {
            return "";
        }
        Map<String, String> params = ServiceInstanceMetadataUtils.getParams(url = url.removeParameters(new String[]{"application", "group", "deprecated", "timestamp"}));
        if (params.isEmpty()) {
            return null;
        }
        return gson.toJson(params);
    }

    private static Map<String, String> getParams(URL providerURL) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        ServiceInstanceMetadataUtils.setDefaultParams(params, providerURL);
        params.put("port", String.valueOf(providerURL.getPort()));
        params.put("protocol", providerURL.getProtocol());
        return params;
    }

    public static String getExportedServicesRevision(ServiceInstance serviceInstance) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        return metadata.get(EXPORTED_SERVICES_REVISION_PROPERTY_NAME);
    }

    public static String getMetadataStorageType(URL registryURL) {
        return registryURL.getParameter(METADATA_STORAGE_TYPE_PROPERTY_NAME, "local");
    }

    public static String getMetadataStorageType(ServiceInstance serviceInstance) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        return metadata.getOrDefault(METADATA_STORAGE_TYPE_PROPERTY_NAME, "local");
    }

    public static void setMetadataStorageType(ServiceInstance serviceInstance, String metadataType) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        metadata.put(METADATA_STORAGE_TYPE_PROPERTY_NAME, metadataType);
    }

    public static String getRemoteCluster(ServiceInstance serviceInstance) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        return metadata.get(METADATA_CLUSTER_PROPERTY_NAME);
    }

    public static boolean hasEndpoints(ServiceInstance serviceInstance) {
        return StringUtils.isNotEmpty((String)serviceInstance.getMetadata().get(ENDPOINTS));
    }

    public static void setEndpoints(ServiceInstance serviceInstance, Map<String, Integer> protocolPorts) {
        Map<String, String> metadata = serviceInstance.getMetadata();
        ArrayList endpoints = new ArrayList();
        protocolPorts.forEach((k, v) -> {
            DefaultServiceInstance.Endpoint endpoint = new DefaultServiceInstance.Endpoint((int)v, (String)k);
            endpoints.add(endpoint);
        });
        metadata.put(ENDPOINTS, gson.toJson(endpoints));
    }

    public static DefaultServiceInstance.Endpoint getEndpoint(ServiceInstance serviceInstance, String protocol) {
        List<DefaultServiceInstance.Endpoint> endpoints = ((DefaultServiceInstance)serviceInstance).getEndpoints();
        if (endpoints != null) {
            for (DefaultServiceInstance.Endpoint endpoint : endpoints) {
                if (!endpoint.getProtocol().equals(protocol)) continue;
                return endpoint;
            }
        }
        return null;
    }

    public static void registerMetadataAndInstance(ApplicationModel applicationModel) {
        LOGGER.info("Start registering instance address to registry.");
        RegistryManager registryManager = (RegistryManager)applicationModel.getBeanFactory().getBean(RegistryManager.class);
        registryManager.getServiceDiscoveries().forEach(ServiceDiscovery::register);
    }

    public static void refreshMetadataAndInstance(ApplicationModel applicationModel) {
        RegistryManager registryManager = (RegistryManager)applicationModel.getBeanFactory().getBean(RegistryManager.class);
        registryManager.getServiceDiscoveries().forEach(ServiceDiscovery::update);
    }

    public static void unregisterMetadataAndInstance(ApplicationModel applicationModel) {
        RegistryManager registryManager = (RegistryManager)applicationModel.getBeanFactory().getBean(RegistryManager.class);
        registryManager.getServiceDiscoveries().forEach(serviceDiscovery -> {
            try {
                serviceDiscovery.unregister();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static void customizeInstance(ServiceInstance instance, ApplicationModel applicationModel) {
        ExtensionLoader loader = instance.getOrDefaultApplicationModel().getExtensionLoader(ServiceInstanceCustomizer.class);
        loader.getSupportedExtensionInstances().forEach(customizer -> customizer.customize(instance, applicationModel));
    }

    public static boolean isValidInstance(ServiceInstance instance) {
        return instance != null && instance.getHost() != null && instance.getPort() != 0;
    }

    private static void setDefaultParams(Map<String, String> params, URL providerURL) {
        for (String parameterName : InterfaceCompatibleRegistryProtocol.DEFAULT_REGISTER_PROVIDER_KEYS) {
            String parameterValue = providerURL.getParameter(parameterName);
            if (StringUtils.isBlank((CharSequence)parameterValue)) continue;
            params.put(parameterName, parameterValue);
        }
    }
}

