/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;

public abstract class RegistryNotifier {
    private static final Logger logger = LoggerFactory.getLogger(RegistryNotifier.class);
    private volatile long lastExecuteTime;
    private volatile long lastEventTime;
    private Object rawAddresses;
    private long delayTime;
    private final AtomicBoolean shouldDelay = new AtomicBoolean(false);
    private final AtomicInteger executeTime = new AtomicInteger(0);
    private ScheduledExecutorService scheduler;

    public RegistryNotifier(URL registryUrl, long delayTime) {
        this(registryUrl, delayTime, null);
    }

    public RegistryNotifier(URL registryUrl, long delayTime, ScheduledExecutorService scheduler) {
        this.delayTime = delayTime;
        this.scheduler = scheduler == null ? ((FrameworkExecutorRepository)registryUrl.getOrDefaultFrameworkModel().getBeanFactory().getBean(FrameworkExecutorRepository.class)).getRegistryNotificationExecutor() : scheduler;
    }

    public synchronized void notify(Object rawAddresses) {
        boolean delay;
        long notifyTime;
        this.rawAddresses = rawAddresses;
        this.lastEventTime = notifyTime = System.currentTimeMillis();
        long delta = System.currentTimeMillis() - this.lastExecuteTime - this.delayTime;
        boolean bl = delay = this.shouldDelay.get() && delta < 0L;
        if (delay) {
            this.scheduler.schedule(new NotificationTask(this, notifyTime), -delta, TimeUnit.MILLISECONDS);
        } else {
            if (!this.shouldDelay.get() && this.executeTime.incrementAndGet() > 10) {
                this.shouldDelay.set(true);
            }
            this.scheduler.submit(new NotificationTask(this, notifyTime));
        }
    }

    public long getDelayTime() {
        return this.delayTime;
    }

    protected abstract void doNotify(Object var1);

    public static class NotificationTask
    implements Runnable {
        private final RegistryNotifier listener;
        private final long time;

        public NotificationTask(RegistryNotifier listener, long time) {
            this.listener = listener;
            this.time = time;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: {
                try {
                    if (this.time != this.listener.lastEventTime) break block6;
                    this.listener.doNotify(this.listener.rawAddresses);
                    this.listener.lastExecuteTime = System.currentTimeMillis();
                    RegistryNotifier registryNotifier = this.listener;
                    synchronized (registryNotifier) {
                        if (this.time == this.listener.lastEventTime) {
                            this.listener.rawAddresses = null;
                        }
                    }
                }
                catch (Throwable t) {
                    logger.error("Error occurred when notify directory. ", t);
                }
            }
        }
    }
}

