/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.metadata;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentNavigableMap;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.ServiceInstanceCustomizer;
import org.apache.dubbo.registry.client.metadata.ServiceInstanceMetadataUtils;
import org.apache.dubbo.rpc.model.ApplicationModel;

public class ProtocolPortsMetadataCustomizer
implements ServiceInstanceCustomizer {
    @Override
    public void customize(ServiceInstance serviceInstance, ApplicationModel applicationModel) {
        MetadataInfo metadataInfo = serviceInstance.getServiceMetadata();
        if (metadataInfo == null || CollectionUtils.isEmptyMap((Map)metadataInfo.getExportedServiceURLs())) {
            return;
        }
        HashMap<String, Integer> protocols = new HashMap<String, Integer>();
        HashSet urls = new HashSet();
        ConcurrentNavigableMap exportedURLS = metadataInfo.getExportedServiceURLs();
        for (Map.Entry entry : exportedURLS.entrySet()) {
            if (entry.getValue() == null) continue;
            urls.addAll((Collection)entry.getValue());
        }
        urls.forEach(url -> protocols.put(url.getProtocol(), url.getPort()));
        if (protocols.size() > 0) {
            ServiceInstanceMetadataUtils.setEndpoints(serviceInstance, protocols);
        }
    }
}

