/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.support.RegistryManager;
import org.apache.dubbo.rpc.model.ApplicationModel;

public abstract class AbstractRegistry
implements Registry {
    private static final char URL_SEPARATOR = ' ';
    private static final String URL_SPLIT = "\\s+";
    private static final int MAX_RETRY_TIMES_SAVE_PROPERTIES = 3;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Properties properties = new Properties();
    private final ExecutorService registryCacheExecutor;
    private final AtomicLong lastCacheChanged = new AtomicLong();
    private final AtomicInteger savePropertiesRetryTimes = new AtomicInteger();
    private final Set<URL> registered = new ConcurrentHashSet();
    private final ConcurrentMap<URL, Set<NotifyListener>> subscribed = new ConcurrentHashMap<URL, Set<NotifyListener>>();
    private final ConcurrentMap<URL, Map<String, List<URL>>> notified = new ConcurrentHashMap<URL, Map<String, List<URL>>>();
    private boolean syncSaveFile;
    private URL registryUrl;
    private File file;
    private boolean localCacheEnabled;
    protected RegistryManager registryManager;
    protected ApplicationModel applicationModel;

    public AbstractRegistry(URL url) {
        this.setUrl(url);
        this.registryManager = (RegistryManager)url.getOrDefaultApplicationModel().getBeanFactory().getBean(RegistryManager.class);
        this.localCacheEnabled = url.getParameter("file.cache", true);
        this.registryCacheExecutor = ((FrameworkExecutorRepository)url.getOrDefaultFrameworkModel().getBeanFactory().getBean(FrameworkExecutorRepository.class)).getSharedExecutor();
        if (this.localCacheEnabled) {
            this.syncSaveFile = url.getParameter("save.file", false);
            String defaultFilename = System.getProperty("user.home") + "/.dubbo/dubbo-registry-" + url.getApplication() + "-" + url.getAddress().replaceAll(":", "-") + ".cache";
            String filename = url.getParameter("file", defaultFilename);
            File file = null;
            if (ConfigUtils.isNotEmpty((String)filename) && !(file = new File(filename)).exists() && file.getParentFile() != null && !file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IllegalArgumentException("Invalid registry cache file " + file + ", cause: Failed to create directory " + file.getParentFile() + "!");
            }
            this.file = file;
            this.loadProperties();
            this.notify(url.getBackupUrls());
        }
    }

    protected static List<URL> filterEmpty(URL url, List<URL> urls) {
        if (CollectionUtils.isEmpty(urls)) {
            ArrayList<URL> result = new ArrayList<URL>(1);
            result.add(url.setProtocol("empty"));
            return result;
        }
        return urls;
    }

    public URL getUrl() {
        return this.registryUrl;
    }

    protected void setUrl(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("registry url == null");
        }
        this.registryUrl = url;
    }

    public Set<URL> getRegistered() {
        return Collections.unmodifiableSet(this.registered);
    }

    public Map<URL, Set<NotifyListener>> getSubscribed() {
        return Collections.unmodifiableMap(this.subscribed);
    }

    public Map<URL, Map<String, List<URL>>> getNotified() {
        return Collections.unmodifiableMap(this.notified);
    }

    public File getCacheFile() {
        return this.file;
    }

    public Properties getCacheProperties() {
        return this.properties;
    }

    public AtomicLong getLastCacheChanged() {
        return this.lastCacheChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doSaveProperties(long version) {
        if (version < this.lastCacheChanged.get()) {
            return;
        }
        if (this.file == null) {
            return;
        }
        File lockfile = null;
        try {
            lockfile = new File(this.file.getAbsolutePath() + ".lock");
            if (!lockfile.exists()) {
                lockfile.createNewFile();
            }
            try (RandomAccessFile raf = new RandomAccessFile(lockfile, "rw");
                 FileChannel channel = raf.getChannel();){
                FileLock lock = channel.tryLock();
                if (lock == null) {
                    throw new IOException("Can not lock the registry cache file " + this.file.getAbsolutePath() + ", ignore and retry later, maybe multi java process use the file, please config: dubbo.registry.file=xxx.properties");
                }
                try {
                    Properties tmpProperties;
                    if (!this.file.exists()) {
                        this.file.createNewFile();
                    }
                    if (this.syncSaveFile) {
                        tmpProperties = this.properties;
                    } else {
                        tmpProperties = new Properties();
                        Set<Map.Entry<Object, Object>> entries = this.properties.entrySet();
                        for (Map.Entry<Object, Object> entry : entries) {
                            tmpProperties.setProperty((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    try (FileOutputStream outputFile = new FileOutputStream(this.file);){
                        tmpProperties.store(outputFile, "Dubbo Registry Cache");
                    }
                }
                finally {
                    lock.release();
                }
            }
            if (lockfile == null || lockfile.delete()) return;
        }
        catch (Throwable e) {
            block38: {
                block37: {
                    try {
                        this.savePropertiesRetryTimes.incrementAndGet();
                        if (this.savePropertiesRetryTimes.get() < 3) break block37;
                        if (e instanceof OverlappingFileLockException) {
                            this.logger.info("Failed to save registry cache file for file overlapping lock exception, file name " + this.file.getName());
                        } else {
                            this.logger.warn("Failed to save registry cache file after retrying 3 times, cause: " + e.getMessage(), e);
                        }
                        this.savePropertiesRetryTimes.set(0);
                        if (lockfile == null || lockfile.delete()) return;
                    }
                    catch (Throwable throwable) {
                        if (lockfile == null || lockfile.delete()) throw throwable;
                        this.logger.warn(String.format("Failed to delete lock file [%s]", lockfile.getName()));
                        throw throwable;
                    }
                    this.logger.warn(String.format("Failed to delete lock file [%s]", lockfile.getName()));
                    return;
                }
                if (version >= this.lastCacheChanged.get()) break block38;
                this.savePropertiesRetryTimes.set(0);
                if (lockfile == null || lockfile.delete()) return;
                this.logger.warn(String.format("Failed to delete lock file [%s]", lockfile.getName()));
                return;
            }
            this.registryCacheExecutor.execute(new SaveProperties(this.lastCacheChanged.incrementAndGet()));
            if (!(e instanceof OverlappingFileLockException)) {
                this.logger.warn("Failed to save registry cache file, will retry, cause: " + e.getMessage(), e);
            }
            if (lockfile == null || lockfile.delete()) return;
            this.logger.warn(String.format("Failed to delete lock file [%s]", lockfile.getName()));
            return;
        }
        this.logger.warn(String.format("Failed to delete lock file [%s]", lockfile.getName()));
        return;
    }

    private void loadProperties() {
        if (this.file != null && this.file.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(this.file);
                this.properties.load(in);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Loaded registry cache file " + this.file);
                }
            }
            catch (Throwable e) {
                this.logger.warn("Failed to load registry cache file " + this.file, e);
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        this.logger.warn(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    public List<URL> getCacheUrls(URL url) {
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!StringUtils.isNotEmpty((String)key) || !key.equals(url.getServiceKey()) || !Character.isLetter(key.charAt(0)) && key.charAt(0) != '_' || !StringUtils.isNotEmpty((String)value)) continue;
            String[] arr = value.trim().split(URL_SPLIT);
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String u : arr) {
                urls.add(URL.valueOf((String)u));
            }
            return urls;
        }
        return null;
    }

    @Override
    public List<URL> lookup(URL url) {
        ArrayList<URL> result;
        block4: {
            block3: {
                result = new ArrayList<URL>();
                Map<String, List<URL>> notifiedUrls = this.getNotified().get(url);
                if (!CollectionUtils.isNotEmptyMap(notifiedUrls)) break block3;
                for (List<URL> urls : notifiedUrls.values()) {
                    for (URL u : urls) {
                        if ("empty".equals(u.getProtocol())) continue;
                        result.add(u);
                    }
                }
                break block4;
            }
            AtomicReference reference = new AtomicReference();
            NotifyListener listener = reference::set;
            this.subscribe(url, listener);
            List urls = (List)reference.get();
            if (!CollectionUtils.isNotEmpty((Collection)urls)) break block4;
            for (URL u : urls) {
                if ("empty".equals(u.getProtocol())) continue;
                result.add(u);
            }
        }
        return result;
    }

    @Override
    public void register(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("register url == null");
        }
        if (url.getPort() != 0 && this.logger.isInfoEnabled()) {
            this.logger.info("Register: " + url);
        }
        this.registered.add(url);
    }

    @Override
    public void unregister(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("unregister url == null");
        }
        if (url.getPort() != 0 && this.logger.isInfoEnabled()) {
            this.logger.info("Unregister: " + url);
        }
        this.registered.remove(url);
    }

    @Override
    public void subscribe(URL url, NotifyListener listener) {
        if (url == null) {
            throw new IllegalArgumentException("subscribe url == null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("subscribe listener == null");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Subscribe: " + url);
        }
        Set listeners = this.subscribed.computeIfAbsent(url, n -> new ConcurrentHashSet());
        listeners.add(listener);
    }

    @Override
    public void unsubscribe(URL url, NotifyListener listener) {
        Set listeners;
        if (url == null) {
            throw new IllegalArgumentException("unsubscribe url == null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("unsubscribe listener == null");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Unsubscribe: " + url);
        }
        if ((listeners = (Set)this.subscribed.get(url)) != null) {
            listeners.remove(listener);
        }
        this.notified.remove(url);
    }

    protected void recover() throws Exception {
        HashMap<URL, Set<NotifyListener>> recoverSubscribed;
        HashSet<URL> recoverRegistered = new HashSet<URL>(this.getRegistered());
        if (!recoverRegistered.isEmpty()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Recover register url " + recoverRegistered);
            }
            for (URL url : recoverRegistered) {
                this.register(url);
            }
        }
        if (!(recoverSubscribed = new HashMap<URL, Set<NotifyListener>>(this.getSubscribed())).isEmpty()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Recover subscribe url " + recoverSubscribed.keySet());
            }
            for (Map.Entry entry : recoverSubscribed.entrySet()) {
                URL url = (URL)entry.getKey();
                for (NotifyListener listener : (Set)entry.getValue()) {
                    this.subscribe(url, listener);
                }
            }
        }
    }

    protected void notify(List<URL> urls) {
        if (CollectionUtils.isEmpty(urls)) {
            return;
        }
        for (Map.Entry<URL, Set<NotifyListener>> entry : this.getSubscribed().entrySet()) {
            Set<NotifyListener> listeners;
            URL url = entry.getKey();
            if (!UrlUtils.isMatch((URL)url, (URL)urls.get(0)) || (listeners = entry.getValue()) == null) continue;
            for (NotifyListener listener : listeners) {
                try {
                    this.notify(url, listener, AbstractRegistry.filterEmpty(url, urls));
                }
                catch (Throwable t) {
                    this.logger.error("Failed to notify registry event, urls: " + urls + ", cause: " + t.getMessage(), t);
                }
            }
        }
    }

    protected void notify(URL url, NotifyListener listener, List<URL> urls) {
        if (url == null) {
            throw new IllegalArgumentException("notify url == null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("notify listener == null");
        }
        if (CollectionUtils.isEmpty(urls) && !"*".equals(url.getServiceInterface())) {
            this.logger.warn("Ignore empty notify urls for subscribe url " + url);
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Notify urls for subscribe url " + url + ", url size: " + urls.size());
        }
        HashMap<String, List> result = new HashMap<String, List>();
        for (URL u2 : urls) {
            if (!UrlUtils.isMatch((URL)url, (URL)u2)) continue;
            String category = u2.getCategory("providers");
            List categoryList = result.computeIfAbsent(category, k -> new ArrayList());
            categoryList.add(u2);
        }
        if (result.size() == 0) {
            return;
        }
        Map categoryNotified = this.notified.computeIfAbsent(url, u -> new ConcurrentHashMap());
        for (Map.Entry entry : result.entrySet()) {
            String category = (String)entry.getKey();
            List categoryList = (List)entry.getValue();
            categoryNotified.put(category, categoryList);
            listener.notify(categoryList);
            if (!this.localCacheEnabled) continue;
            this.saveProperties(url);
        }
    }

    private void saveProperties(URL url) {
        if (this.file == null) {
            return;
        }
        try {
            StringBuilder buf = new StringBuilder();
            Map categoryNotified = (Map)this.notified.get(url);
            if (categoryNotified != null) {
                for (List us : categoryNotified.values()) {
                    for (URL u : us) {
                        if (buf.length() > 0) {
                            buf.append(' ');
                        }
                        buf.append(u.toFullString());
                    }
                }
            }
            this.properties.setProperty(url.getServiceKey(), buf.toString());
            long version = this.lastCacheChanged.incrementAndGet();
            if (this.syncSaveFile) {
                this.doSaveProperties(version);
            } else {
                this.registryCacheExecutor.execute(new SaveProperties(version));
            }
        }
        catch (Throwable t) {
            this.logger.warn(t.getMessage(), t);
        }
    }

    public void destroy() {
        HashMap<URL, Set<NotifyListener>> destroySubscribed;
        HashSet<URL> destroyRegistered;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Destroy registry:" + this.getUrl());
        }
        if (!(destroyRegistered = new HashSet<URL>(this.getRegistered())).isEmpty()) {
            for (URL url : new HashSet<URL>(destroyRegistered)) {
                if (!url.getParameter("dynamic", true)) continue;
                try {
                    this.unregister(url);
                    if (!this.logger.isInfoEnabled()) continue;
                    this.logger.info("Destroy unregister url " + url);
                }
                catch (Throwable t) {
                    this.logger.warn("Failed to unregister url " + url + " to registry " + this.getUrl() + " on destroy, cause: " + t.getMessage(), t);
                }
            }
        }
        if (!(destroySubscribed = new HashMap<URL, Set<NotifyListener>>(this.getSubscribed())).isEmpty()) {
            for (Map.Entry entry : destroySubscribed.entrySet()) {
                URL url = (URL)entry.getKey();
                for (NotifyListener listener : (Set)entry.getValue()) {
                    try {
                        this.unsubscribe(url, listener);
                        if (!this.logger.isInfoEnabled()) continue;
                        this.logger.info("Destroy unsubscribe url " + url);
                    }
                    catch (Throwable t) {
                        this.logger.warn("Failed to unsubscribe url " + url + " to registry " + this.getUrl() + " on destroy, cause: " + t.getMessage(), t);
                    }
                }
            }
        }
        this.registryManager.removeDestroyedRegistry(this);
    }

    protected boolean acceptable(URL urlToRegistry) {
        String pattern = this.registryUrl.getParameter("accepts");
        if (StringUtils.isEmpty((String)pattern)) {
            return true;
        }
        String[] accepts = CommonConstants.COMMA_SPLIT_PATTERN.split(pattern);
        Set allow = Arrays.stream(accepts).filter(p -> !p.startsWith("-")).collect(Collectors.toSet());
        Set disAllow = Arrays.stream(accepts).filter(p -> p.startsWith("-")).map(p -> p.substring(1)).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(allow)) {
            return allow.contains(urlToRegistry.getProtocol());
        }
        if (CollectionUtils.isNotEmpty(disAllow)) {
            return !disAllow.contains(urlToRegistry.getProtocol());
        }
        return true;
    }

    public String toString() {
        return this.getUrl().toString();
    }

    private class SaveProperties
    implements Runnable {
        private long version;

        private SaveProperties(long version) {
            this.version = version;
        }

        @Override
        public void run() {
            AbstractRegistry.this.doSaveProperties(this.version);
        }
    }
}

