/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.client.migration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.ConfigurationUtils;
import org.apache.dubbo.common.config.configcenter.ConfigChangedEvent;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.client.migration.MigrationInvoker;
import org.apache.dubbo.registry.client.migration.MigrationRuleHandler;
import org.apache.dubbo.registry.client.migration.model.MigrationRule;
import org.apache.dubbo.registry.integration.RegistryProtocol;
import org.apache.dubbo.registry.integration.RegistryProtocolListener;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModel;

@Activate
public class MigrationRuleListener
implements RegistryProtocolListener,
ConfigurationListener {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(MigrationRuleListener.class);
    private static final String DUBBO_SERVICEDISCOVERY_MIGRATION = "DUBBO_SERVICEDISCOVERY_MIGRATION";
    private static final String MIGRATION_DELAY_KEY = "dubbo.application.migration.delay";
    private static final int MIGRATION_DEFAULT_DELAY_TIME = 60000;
    private String ruleKey;
    protected final ConcurrentMap<MigrationInvoker<?>, MigrationRuleHandler<?>> handlers = new ConcurrentHashMap();
    protected final LinkedBlockingQueue<String> ruleQueue = new LinkedBlockingQueue();
    private final AtomicBoolean executorSubmit = new AtomicBoolean(false);
    private final ExecutorService ruleManageExecutor = Executors.newFixedThreadPool(1, (ThreadFactory)new NamedThreadFactory("Dubbo-Migration-Listener"));
    protected ScheduledFuture<?> localRuleMigrationFuture;
    protected Future<?> ruleMigrationFuture;
    private DynamicConfiguration configuration;
    private volatile String rawRule;
    private volatile MigrationRule rule;
    private final ModuleModel moduleModel;

    public MigrationRuleListener(ModuleModel moduleModel) {
        this.moduleModel = moduleModel;
        this.init();
    }

    private void init() {
        this.ruleKey = this.moduleModel.getApplicationModel().getApplicationName() + ".migration";
        this.configuration = this.moduleModel.modelEnvironment().getDynamicConfiguration().orElse(null);
        if (this.configuration != null) {
            logger.info("Listening for migration rules on dataId " + this.ruleKey + ", group " + DUBBO_SERVICEDISCOVERY_MIGRATION);
            this.configuration.addListener(this.ruleKey, DUBBO_SERVICEDISCOVERY_MIGRATION, (ConfigurationListener)this);
            String rawRule = this.configuration.getConfig(this.ruleKey, DUBBO_SERVICEDISCOVERY_MIGRATION);
            if (StringUtils.isEmpty((String)rawRule)) {
                rawRule = "INIT";
            }
            this.setRawRule(rawRule);
        } else {
            if (logger.isWarnEnabled()) {
                logger.warn("1-4", "", "", "Using default configuration rule because config center is not configured!");
            }
            this.setRawRule("INIT");
        }
        String localRawRule = this.moduleModel.modelEnvironment().getLocalMigrationRule();
        if (!StringUtils.isEmpty((String)localRawRule)) {
            this.localRuleMigrationFuture = ((FrameworkExecutorRepository)this.moduleModel.getApplicationModel().getFrameworkModel().getBeanFactory().getBean(FrameworkExecutorRepository.class)).getSharedScheduledExecutor().schedule(() -> {
                if (this.rawRule.equals("INIT")) {
                    this.process(new ConfigChangedEvent(null, null, localRawRule));
                }
            }, (long)this.getDelay(), TimeUnit.MILLISECONDS);
        }
    }

    private int getDelay() {
        int delay = 60000;
        String delayStr = ConfigurationUtils.getProperty((ScopeModel)this.moduleModel, (String)MIGRATION_DELAY_KEY);
        if (StringUtils.isEmpty((String)delayStr)) {
            return delay;
        }
        try {
            delay = Integer.parseInt(delayStr);
        }
        catch (Exception e) {
            logger.warn("0-2", "", "", "Invalid migration delay param " + delayStr);
        }
        return delay;
    }

    public synchronized void process(ConfigChangedEvent event) {
        String rawRule = event.getContent();
        if (StringUtils.isEmpty((String)rawRule)) {
            rawRule = "INIT";
        }
        try {
            this.ruleQueue.put(rawRule);
        }
        catch (InterruptedException e) {
            logger.error("0-6", "", "", "Put rawRule to rule management queue failed. rawRule: " + rawRule, (Throwable)e);
        }
        if (this.executorSubmit.compareAndSet(false, true)) {
            this.ruleMigrationFuture = this.ruleManageExecutor.submit(() -> {
                block10: while (true) {
                    String rule = "";
                    try {
                        rule = this.ruleQueue.take();
                        if (StringUtils.isEmpty((String)rule)) {
                            Thread.sleep(1000L);
                        }
                    }
                    catch (InterruptedException e) {
                        logger.error("0-6", "", "", "Poll Rule from config center failed.", (Throwable)e);
                    }
                    if (StringUtils.isEmpty((String)rule)) continue;
                    if (Objects.equals(this.rawRule, rule)) {
                        logger.info("Ignore duplicated rule");
                        continue;
                    }
                    logger.info("Using the following migration rule to migrate:");
                    logger.info(rule);
                    this.setRawRule(rule);
                    if (CollectionUtils.isEmptyMap(this.handlers)) continue;
                    ExecutorService executorService = null;
                    try {
                        executorService = Executors.newFixedThreadPool(Math.min(this.handlers.size(), 100), (ThreadFactory)new NamedThreadFactory("Dubbo-Invoker-Migrate"));
                        ArrayList migrationFutures = new ArrayList(this.handlers.size());
                        for (MigrationRuleHandler handler : this.handlers.values()) {
                            Future<?> future = executorService.submit(() -> handler.doMigrate(this.rule));
                            migrationFutures.add(future);
                        }
                        Iterator<Object> iterator = migrationFutures.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block10;
                            Future future = (Future)iterator.next();
                            try {
                                future.get();
                            }
                            catch (InterruptedException ie) {
                                logger.warn("99-0", "unknown error in registry module", "", "Interrupted while waiting for migration async task to finish.");
                            }
                            catch (ExecutionException ee) {
                                logger.error("99-0", "unknown error in registry module", "", "Migration async task failed.", ee.getCause());
                            }
                        }
                    }
                    catch (Throwable t) {
                        logger.error("99-0", "unknown error in registry module", "", "Error occurred when migration.", t);
                        continue;
                    }
                    finally {
                        if (executorService == null) continue;
                        executorService.shutdown();
                        continue;
                    }
                    break;
                }
            });
        }
    }

    public void setRawRule(String rawRule) {
        this.rawRule = rawRule;
        this.rule = this.parseRule(this.rawRule);
    }

    private MigrationRule parseRule(String rawRule) {
        MigrationRule tmpRule;
        MigrationRule migrationRule = tmpRule = this.rule == null ? MigrationRule.getInitRule() : this.rule;
        if ("INIT".equals(rawRule)) {
            tmpRule = MigrationRule.getInitRule();
        } else {
            try {
                tmpRule = MigrationRule.parse(rawRule);
            }
            catch (Exception e) {
                logger.error("0-2", "", "", "Failed to parse migration rule...", (Throwable)e);
            }
        }
        return tmpRule;
    }

    @Override
    public void onExport(RegistryProtocol registryProtocol, Exporter<?> exporter) {
    }

    @Override
    public void onRefer(RegistryProtocol registryProtocol, ClusterInvoker<?> invoker, URL consumerUrl, URL registryURL) {
        MigrationRuleHandler migrationRuleHandler = (MigrationRuleHandler)ConcurrentHashMapUtils.computeIfAbsent(this.handlers, (Object)((MigrationInvoker)invoker), _key -> {
            ((MigrationInvoker)invoker).setMigrationRuleListener(this);
            return new MigrationRuleHandler((MigrationInvoker)invoker, consumerUrl);
        });
        migrationRuleHandler.doMigrate(this.rule);
    }

    @Override
    public void onDestroy() {
        if (this.configuration != null) {
            this.configuration.removeListener(this.ruleKey, DUBBO_SERVICEDISCOVERY_MIGRATION, (ConfigurationListener)this);
        }
        if (this.ruleMigrationFuture != null) {
            this.ruleMigrationFuture.cancel(true);
        }
        if (this.localRuleMigrationFuture != null) {
            this.localRuleMigrationFuture.cancel(true);
        }
        this.ruleManageExecutor.shutdown();
        this.ruleQueue.clear();
    }

    public Map<MigrationInvoker<?>, MigrationRuleHandler<?>> getHandlers() {
        return this.handlers;
    }

    protected void removeMigrationInvoker(MigrationInvoker<?> migrationInvoker) {
        this.handlers.remove(migrationInvoker);
    }

    public MigrationRule getRule() {
        return this.rule;
    }
}

