/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.integration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.config.configcenter.ConfigurationListener;
import org.apache.dubbo.common.config.configcenter.DynamicConfiguration;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.deploy.ApplicationDeployer;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.timer.HashedWheelTimer;
import org.apache.dubbo.common.timer.TimerTask;
import org.apache.dubbo.common.url.component.ServiceConfigURL;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.common.utils.UrlUtils;
import org.apache.dubbo.metrics.event.MetricsEvent;
import org.apache.dubbo.metrics.event.MetricsEventBus;
import org.apache.dubbo.metrics.registry.event.RegistryEvent;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.Registry;
import org.apache.dubbo.registry.RegistryFactory;
import org.apache.dubbo.registry.RegistryService;
import org.apache.dubbo.registry.client.ServiceDiscoveryRegistryDirectory;
import org.apache.dubbo.registry.client.migration.MigrationClusterInvoker;
import org.apache.dubbo.registry.client.migration.ServiceDiscoveryMigrationInvoker;
import org.apache.dubbo.registry.integration.AbstractConfiguratorListener;
import org.apache.dubbo.registry.integration.DynamicDirectory;
import org.apache.dubbo.registry.integration.ExporterFactory;
import org.apache.dubbo.registry.integration.ReferenceCountExporter;
import org.apache.dubbo.registry.integration.RegistryDirectory;
import org.apache.dubbo.registry.integration.RegistryProtocolListener;
import org.apache.dubbo.registry.integration.ServiceURLCustomizer;
import org.apache.dubbo.registry.retry.ReExportTask;
import org.apache.dubbo.registry.support.SkipFailbackWrapperException;
import org.apache.dubbo.rpc.Exporter;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProtocolServer;
import org.apache.dubbo.rpc.ProxyFactory;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Cluster;
import org.apache.dubbo.rpc.cluster.ClusterInvoker;
import org.apache.dubbo.rpc.cluster.Configurator;
import org.apache.dubbo.rpc.cluster.governance.GovernanceRuleRepository;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ProviderModel;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;
import org.apache.dubbo.rpc.model.ScopeModelUtil;
import org.apache.dubbo.rpc.protocol.InvokerWrapper;
import org.apache.dubbo.rpc.support.ProtocolUtils;

public class RegistryProtocol
implements Protocol,
ScopeModelAware {
    public static final String[] DEFAULT_REGISTER_PROVIDER_KEYS = new String[]{"application", "codec", "exchanger", "serialization", "prefer.serialization", "cluster", "connections", "deprecated", "group", "loadbalance", "mock", "path", "timeout", "token", "version", "warmup", "weight", "dubbo", "release", "side", "ipv6", "serialize.packable.factory"};
    public static final String[] DEFAULT_REGISTER_CONSUMER_KEYS = new String[]{"application", "version", "group", "dubbo", "release"};
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(RegistryProtocol.class);
    private final Map<String, ServiceConfigurationListener> serviceConfigurationListeners = new ConcurrentHashMap<String, ServiceConfigurationListener>();
    private final Map<String, Map<String, ExporterChangeableWrapper<?>>> bounds = new ConcurrentHashMap();
    protected Protocol protocol;
    protected ProxyFactory proxyFactory;
    private ConcurrentMap<URL, ReExportTask> reExportFailedTasks = new ConcurrentHashMap<URL, ReExportTask>();
    private HashedWheelTimer retryTimer = new HashedWheelTimer((ThreadFactory)new NamedThreadFactory("DubboReexportTimer", true), 5000L, TimeUnit.MILLISECONDS, 128);
    private FrameworkModel frameworkModel;
    private ExporterFactory exporterFactory;

    public void setFrameworkModel(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
        this.exporterFactory = (ExporterFactory)frameworkModel.getBeanFactory().getBean(ExporterFactory.class);
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setProxyFactory(ProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public int getDefaultPort() {
        return 9090;
    }

    public Map<URL, Set<NotifyListener>> getOverrideListeners() {
        HashMap<URL, Set<NotifyListener>> map = new HashMap<URL, Set<NotifyListener>>();
        List applicationModels = this.frameworkModel.getApplicationModels();
        if (applicationModels.size() == 1) {
            return ((ProviderConfigurationListener)((ApplicationModel)applicationModels.get(0)).getBeanFactory().getBean(ProviderConfigurationListener.class)).getOverrideListeners();
        }
        for (ApplicationModel applicationModel : applicationModels) {
            map.putAll(((ProviderConfigurationListener)applicationModel.getBeanFactory().getBean(ProviderConfigurationListener.class)).getOverrideListeners());
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void register(Registry registry, URL registeredProviderUrl) {
        ApplicationDeployer deployer = registeredProviderUrl.getOrDefaultApplicationModel().getDeployer();
        try {
            deployer.increaseServiceRefreshCount();
            String registryName = Optional.ofNullable(registry.getUrl()).map(u -> u.getParameter("REGISTRY_CLUSTER", UrlUtils.isServiceDiscoveryURL((URL)u) ? u.getParameter("registry") : u.getProtocol())).filter(StringUtils::isNotEmpty).orElse("unknown");
            MetricsEventBus.post((MetricsEvent)RegistryEvent.toRsEvent((ApplicationModel)registeredProviderUrl.getApplicationModel(), (String)registeredProviderUrl.getServiceKey(), (int)1, Collections.singletonList(registryName)), () -> {
                registry.register(registeredProviderUrl);
                return null;
            });
        }
        finally {
            deployer.decreaseServiceRefreshCount();
        }
    }

    private void registerStatedUrl(URL registryUrl, URL registeredProviderUrl, boolean registered) {
        ProviderModel model = (ProviderModel)registeredProviderUrl.getServiceModel();
        model.addStatedUrl(new ProviderModel.RegisterStatedURL(registeredProviderUrl, registryUrl, registered));
    }

    public <T> Exporter<T> export(Invoker<T> originInvoker) throws RpcException {
        boolean register;
        URL registryUrl = this.getRegistryUrl(originInvoker);
        URL providerUrl = this.getProviderUrl(originInvoker);
        URL overrideSubscribeUrl = this.getSubscribedOverrideUrl(providerUrl);
        OverrideListener overrideSubscribeListener = new OverrideListener(overrideSubscribeUrl, originInvoker);
        Map<URL, Set<NotifyListener>> overrideListeners = this.getProviderConfigurationListener(overrideSubscribeUrl).getOverrideListeners();
        overrideListeners.computeIfAbsent(overrideSubscribeUrl, k -> new ConcurrentHashSet()).add(overrideSubscribeListener);
        providerUrl = this.overrideUrlWithConfig(providerUrl, overrideSubscribeListener);
        ExporterChangeableWrapper<T> exporter = this.doLocalExport(originInvoker, providerUrl);
        Registry registry = this.getRegistry(registryUrl);
        URL registeredProviderUrl = this.customizeURL(providerUrl, registryUrl);
        boolean bl = register = providerUrl.getParameter("register", true) && registryUrl.getParameter("register", true);
        if (register) {
            RegistryProtocol.register(registry, registeredProviderUrl);
        }
        this.registerStatedUrl(registryUrl, registeredProviderUrl, register);
        exporter.setRegisterUrl(registeredProviderUrl);
        exporter.setSubscribeUrl(overrideSubscribeUrl);
        exporter.setNotifyListener(overrideSubscribeListener);
        exporter.setRegistered(register);
        ApplicationModel applicationModel = ScopeModelUtil.getApplicationModel((ScopeModel)providerUrl.getScopeModel());
        if (((Boolean)applicationModel.modelEnvironment().getConfiguration().convert(Boolean.class, "enable-26x-configuration-listen", (Object)true)).booleanValue() && !registry.isServiceDiscovery()) {
            registry.subscribe(overrideSubscribeUrl, overrideSubscribeListener);
        }
        this.notifyExport(exporter);
        return new DestroyableExporter<T>(exporter);
    }

    private <T> void notifyExport(ExporterChangeableWrapper<T> exporter) {
        ScopeModel scopeModel = exporter.getRegisterUrl().getScopeModel();
        List listeners = ScopeModelUtil.getExtensionLoader(RegistryProtocolListener.class, (ScopeModel)scopeModel).getActivateExtension(exporter.getOriginInvoker().getUrl(), "registry.protocol.listener");
        if (CollectionUtils.isNotEmpty((Collection)listeners)) {
            for (RegistryProtocolListener listener : listeners) {
                listener.onExport(this, exporter);
            }
        }
    }

    private URL overrideUrlWithConfig(URL providerUrl, OverrideListener listener) {
        ProviderConfigurationListener providerConfigurationListener = this.getProviderConfigurationListener(providerUrl);
        providerUrl = providerConfigurationListener.overrideUrl(providerUrl);
        ServiceConfigurationListener serviceConfigurationListener = new ServiceConfigurationListener(providerUrl.getOrDefaultModuleModel(), providerUrl, listener);
        this.serviceConfigurationListeners.put(providerUrl.getServiceKey(), serviceConfigurationListener);
        return serviceConfigurationListener.overrideUrl(providerUrl);
    }

    private <T> ExporterChangeableWrapper<T> doLocalExport(Invoker<T> originInvoker, URL providerUrl) {
        String providerUrlKey = this.getProviderUrlKey(originInvoker);
        String registryUrlKey = this.getRegistryUrlKey(originInvoker);
        InvokerDelegate invokerDelegate = new InvokerDelegate(originInvoker, providerUrl);
        ReferenceCountExporter<?> exporter = this.exporterFactory.createExporter(providerUrlKey, () -> this.protocol.export(invokerDelegate));
        return this.bounds.computeIfAbsent(providerUrlKey, k -> new ConcurrentHashMap()).computeIfAbsent(registryUrlKey, s -> new ExporterChangeableWrapper(exporter, originInvoker));
    }

    public <T> void reExport(Exporter<T> exporter, URL newInvokerUrl) {
        if (exporter instanceof ExporterChangeableWrapper) {
            ExporterChangeableWrapper exporterWrapper = (ExporterChangeableWrapper)exporter;
            Invoker originInvoker = exporterWrapper.getOriginInvoker();
            this.reExport(originInvoker, newInvokerUrl);
        }
    }

    public <T> void reExport(Invoker<T> originInvoker, URL newInvokerUrl) {
        block6: {
            String providerUrlKey = this.getProviderUrlKey(originInvoker);
            String registryUrlKey = this.getRegistryUrlKey(originInvoker);
            Map<String, ExporterChangeableWrapper<?>> registryMap = this.bounds.get(providerUrlKey);
            if (registryMap == null) {
                logger.warn("99-0", "error state, exporterMap can not be null", "", "error state, exporterMap can not be null", (Throwable)new IllegalStateException("error state, exporterMap can not be null"));
                return;
            }
            ExporterChangeableWrapper<?> exporter = registryMap.get(registryUrlKey);
            if (exporter == null) {
                logger.warn("99-0", "error state, exporterMap can not be null", "", "error state, exporterMap can not be null", (Throwable)new IllegalStateException("error state, exporterMap can not be null"));
                return;
            }
            URL registeredUrl = exporter.getRegisterUrl();
            URL registryUrl = this.getRegistryUrl(originInvoker);
            URL newProviderUrl = this.customizeURL(newInvokerUrl, registryUrl);
            InvokerDelegate<T> invokerDelegate = new InvokerDelegate<T>(originInvoker, newInvokerUrl);
            exporter.setExporter(this.protocol.export(invokerDelegate));
            if (!newProviderUrl.equals((Object)registeredUrl)) {
                try {
                    this.doReExport(originInvoker, exporter, registryUrl, registeredUrl, newProviderUrl);
                }
                catch (Exception e) {
                    ReExportTask oldTask = (ReExportTask)this.reExportFailedTasks.get(registeredUrl);
                    if (oldTask != null) {
                        return;
                    }
                    ReExportTask task = new ReExportTask(() -> this.doReExport(originInvoker, exporter, registryUrl, registeredUrl, newProviderUrl), registeredUrl, null);
                    oldTask = this.reExportFailedTasks.putIfAbsent(registeredUrl, task);
                    if (oldTask != null) break block6;
                    this.retryTimer.newTimeout((TimerTask)task, (long)registryUrl.getParameter("retry.period", 5000), TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    private <T> void doReExport(Invoker<T> originInvoker, ExporterChangeableWrapper<T> exporter, URL registryUrl, URL oldProviderUrl, URL newProviderUrl) {
        if (exporter.isRegistered()) {
            Registry registry;
            try {
                registry = this.getRegistry(this.getRegistryUrl(originInvoker));
            }
            catch (Exception e) {
                throw new SkipFailbackWrapperException(e);
            }
            logger.info("Try to unregister old url: " + oldProviderUrl);
            registry.reExportUnregister(oldProviderUrl);
            logger.info("Try to register new url: " + newProviderUrl);
            registry.reExportRegister(newProviderUrl);
        }
        try {
            ProviderModel.RegisterStatedURL statedUrl = this.getStatedUrl(registryUrl, newProviderUrl);
            statedUrl.setProviderUrl(newProviderUrl);
            exporter.setRegisterUrl(newProviderUrl);
        }
        catch (Exception e) {
            throw new SkipFailbackWrapperException(e);
        }
    }

    private ProviderModel.RegisterStatedURL getStatedUrl(URL registryUrl, URL providerUrl) {
        ProviderModel providerModel = this.frameworkModel.getServiceRepository().lookupExportedService(providerUrl.getServiceKey());
        List statedUrls = providerModel.getStatedUrl();
        return statedUrls.stream().filter(u -> u.getRegistryUrl().equals((Object)registryUrl) && u.getProviderUrl().getProtocol().equals(providerUrl.getProtocol())).findFirst().orElseThrow(() -> new IllegalStateException("There should have at least one registered url."));
    }

    protected Registry getRegistry(URL registryUrl) {
        RegistryFactory registryFactory = (RegistryFactory)ScopeModelUtil.getExtensionLoader(RegistryFactory.class, (ScopeModel)registryUrl.getScopeModel()).getAdaptiveExtension();
        return registryFactory.getRegistry(registryUrl);
    }

    protected URL getRegistryUrl(Invoker<?> originInvoker) {
        return originInvoker.getUrl();
    }

    protected URL getRegistryUrl(URL url) {
        if ("service-discovery-registry".equals(url.getProtocol())) {
            return url;
        }
        return url.addParameter("registry", url.getProtocol()).setProtocol("service-discovery-registry");
    }

    private URL customizeURL(URL providerUrl, URL registryUrl) {
        URL newProviderURL = providerUrl.putAttribute("simplified", (Object)registryUrl.getParameter("simplified", false));
        newProviderURL = newProviderURL.putAttribute("extra-keys", (Object)registryUrl.getParameter("extra-keys", ""));
        ApplicationModel applicationModel = providerUrl.getOrDefaultApplicationModel();
        ExtensionLoader loader = applicationModel.getExtensionLoader(ServiceURLCustomizer.class);
        for (ServiceURLCustomizer customizer : loader.getSupportedExtensionInstances()) {
            newProviderURL = customizer.customize(newProviderURL, applicationModel);
        }
        return newProviderURL;
    }

    private URL getSubscribedOverrideUrl(URL registeredProviderUrl) {
        return registeredProviderUrl.setProtocol("provider").addParameters(new String[]{"category", "configurators", "check", String.valueOf(false)});
    }

    private URL getProviderUrl(Invoker<?> originInvoker) {
        Object providerURL = originInvoker.getUrl().getAttribute("export");
        if (!(providerURL instanceof URL)) {
            throw new IllegalArgumentException("The registry export url is null! registry: " + originInvoker.getUrl().getAddress());
        }
        return (URL)providerURL;
    }

    private String getProviderUrlKey(Invoker<?> originInvoker) {
        URL providerUrl = this.getProviderUrl(originInvoker);
        return providerUrl.removeParameters(new String[]{"dynamic", "enabled"}).toFullString();
    }

    private String getRegistryUrlKey(Invoker<?> originInvoker) {
        URL registryUrl = this.getRegistryUrl(originInvoker);
        return registryUrl.removeParameters(new String[]{"dynamic", "enabled"}).toFullString();
    }

    public <T> Invoker<T> refer(Class<T> type, URL url) throws RpcException {
        url = this.getRegistryUrl(url);
        Registry registry = this.getRegistry(url);
        if (RegistryService.class.equals(type)) {
            return this.proxyFactory.getInvoker((Object)registry, type, url);
        }
        Map qs = (Map)url.getAttribute("refer");
        String group = (String)qs.get("group");
        if (StringUtils.isNotEmpty((String)group) && (CommonConstants.COMMA_SPLIT_PATTERN.split(group).length > 1 || "*".equals(group))) {
            return this.doRefer(Cluster.getCluster((ScopeModel)url.getScopeModel(), (String)"mergeable"), registry, type, url, qs);
        }
        Cluster cluster = Cluster.getCluster((ScopeModel)url.getScopeModel(), (String)((String)qs.get("cluster")));
        return this.doRefer(cluster, registry, type, url, qs);
    }

    protected <T> Invoker<T> doRefer(Cluster cluster, Registry registry, Class<T> type, URL url, Map<String, String> parameters) {
        HashMap consumerAttribute = new HashMap(url.getAttributes());
        consumerAttribute.remove("refer");
        String p = StringUtils.isEmpty((String)parameters.get("protocol")) ? "consumer" : parameters.get("protocol");
        ServiceConfigURL consumerUrl = new ServiceConfigURL(p, null, null, parameters.get("register.ip"), 0, this.getPath(parameters, type), parameters, consumerAttribute);
        url = url.putAttribute("CONSUMER_URL", (Object)consumerUrl);
        ClusterInvoker<T> migrationInvoker = this.getMigrationInvoker(this, cluster, registry, type, url, (URL)consumerUrl);
        return this.interceptInvoker(migrationInvoker, url, (URL)consumerUrl);
    }

    private String getPath(Map<String, String> parameters, Class<?> type) {
        return !ProtocolUtils.isGeneric((String)parameters.get("generic")) ? type.getName() : parameters.get("interface");
    }

    protected <T> ClusterInvoker<T> getMigrationInvoker(RegistryProtocol registryProtocol, Cluster cluster, Registry registry, Class<T> type, URL url, URL consumerUrl) {
        return new ServiceDiscoveryMigrationInvoker<T>(registryProtocol, cluster, registry, type, url, consumerUrl);
    }

    protected <T> Invoker<T> interceptInvoker(ClusterInvoker<T> invoker, URL url, URL consumerUrl) {
        List<RegistryProtocolListener> listeners = this.findRegistryProtocolListeners(url);
        if (CollectionUtils.isEmpty(listeners)) {
            return invoker;
        }
        for (RegistryProtocolListener listener : listeners) {
            listener.onRefer(this, invoker, consumerUrl, url);
        }
        return invoker;
    }

    public <T> ClusterInvoker<T> getServiceDiscoveryInvoker(Cluster cluster, Registry registry, Class<T> type, URL url) {
        ServiceDiscoveryRegistryDirectory<T> directory = new ServiceDiscoveryRegistryDirectory<T>(type, url);
        return this.doCreateInvoker(directory, cluster, registry, type);
    }

    public <T> ClusterInvoker<T> getInvoker(Cluster cluster, Registry registry, Class<T> type, URL url) {
        RegistryDirectory<T> directory = new RegistryDirectory<T>(type, url);
        return this.doCreateInvoker(directory, cluster, registry, type);
    }

    protected <T> ClusterInvoker<T> doCreateInvoker(DynamicDirectory<T> directory, Cluster cluster, Registry registry, Class<T> type) {
        directory.setRegistry(registry);
        directory.setProtocol(this.protocol);
        HashMap<String, String> parameters = new HashMap<String, String>(directory.getConsumerUrl().getParameters());
        ServiceConfigURL urlToRegistry = new ServiceConfigURL(parameters.get("protocol") == null ? "consumer" : (String)parameters.get("protocol"), (String)parameters.remove("register.ip"), 0, this.getPath(parameters, type), parameters);
        urlToRegistry = urlToRegistry.setScopeModel(directory.getConsumerUrl().getScopeModel());
        urlToRegistry = urlToRegistry.setServiceModel(directory.getConsumerUrl().getServiceModel());
        if (directory.isShouldRegister()) {
            directory.setRegisteredConsumerUrl((URL)urlToRegistry);
            registry.register(directory.getRegisteredConsumerUrl());
        }
        directory.buildRouterChain((URL)urlToRegistry);
        directory.subscribe(RegistryProtocol.toSubscribeUrl((URL)urlToRegistry));
        return (ClusterInvoker)cluster.join(directory, true);
    }

    public <T> void reRefer(ClusterInvoker<?> invoker, URL newSubscribeUrl) {
        if (!(invoker instanceof MigrationClusterInvoker)) {
            logger.error("1-16", "", "", "Only invoker type of MigrationClusterInvoker supports reRefer, current invoker is " + invoker.getClass());
            return;
        }
        MigrationClusterInvoker migrationClusterInvoker = (MigrationClusterInvoker)invoker;
        migrationClusterInvoker.reRefer(newSubscribeUrl);
    }

    public static URL toSubscribeUrl(URL url) {
        return url.addParameter("category", "providers,configurators,routers");
    }

    protected List<RegistryProtocolListener> findRegistryProtocolListeners(URL url) {
        return ScopeModelUtil.getExtensionLoader(RegistryProtocolListener.class, (ScopeModel)url.getScopeModel()).getActivateExtension(url, "registry.protocol.listener");
    }

    public void destroy() {
        for (ApplicationModel applicationModel : this.frameworkModel.getApplicationModels()) {
            for (ModuleModel moduleModel : applicationModel.getModuleModels()) {
                List listeners = moduleModel.getExtensionLoader(RegistryProtocolListener.class).getLoadedExtensionInstances();
                if (!CollectionUtils.isNotEmpty((Collection)listeners)) continue;
                for (RegistryProtocolListener listener : listeners) {
                    listener.onDestroy();
                }
            }
        }
        for (ApplicationModel applicationModel : this.frameworkModel.getApplicationModels()) {
            if (!((Boolean)applicationModel.modelEnvironment().getConfiguration().convert(Boolean.class, "enable-configuration-listen", (Object)true)).booleanValue()) continue;
            for (ModuleModel moduleModel : applicationModel.getPubModuleModels()) {
                String applicationName = applicationModel.tryGetApplicationName();
                if (applicationName == null || moduleModel.getServiceRepository().getExportedServices().isEmpty()) continue;
                ((GovernanceRuleRepository)moduleModel.getExtensionLoader(GovernanceRuleRepository.class).getDefaultExtension()).removeListener(applicationName + ".configurators", (ConfigurationListener)this.getProviderConfigurationListener(moduleModel));
            }
        }
        List exporters = this.bounds.values().stream().flatMap(e -> e.values().stream()).collect(Collectors.toList());
        for (Exporter exporter : exporters) {
            exporter.unexport();
        }
        this.bounds.clear();
    }

    public List<ProtocolServer> getServers() {
        return this.protocol.getServers();
    }

    private static URL getConfiguredInvokerUrl(List<Configurator> configurators, URL url) {
        if (CollectionUtils.isNotEmpty(configurators)) {
            for (Configurator configurator : configurators) {
                url = configurator.configure(url);
            }
        }
        return url;
    }

    private ProviderConfigurationListener getProviderConfigurationListener(URL url) {
        return this.getProviderConfigurationListener(url.getOrDefaultModuleModel());
    }

    private ProviderConfigurationListener getProviderConfigurationListener(ModuleModel moduleModel) {
        return (ProviderConfigurationListener)moduleModel.getBeanFactory().getOrRegisterBean(ProviderConfigurationListener.class, type -> new ProviderConfigurationListener(moduleModel));
    }

    private class ProviderConfigurationListener
    extends AbstractConfiguratorListener {
        private final Map<URL, Set<NotifyListener>> overrideListeners;
        private final ModuleModel moduleModel;

        public ProviderConfigurationListener(ModuleModel moduleModel) {
            super(moduleModel);
            this.overrideListeners = new ConcurrentHashMap<URL, Set<NotifyListener>>();
            this.moduleModel = moduleModel;
            if (moduleModel.modelEnvironment().getConfiguration().getBoolean("enable-configuration-listen", true)) {
                this.initWith(moduleModel.getApplicationModel().getApplicationName() + ".configurators");
            }
        }

        private <T> URL overrideUrl(URL providerUrl) {
            return RegistryProtocol.getConfiguredInvokerUrl(this.configurators, providerUrl);
        }

        @Override
        protected void notifyOverrides() {
            ApplicationDeployer deployer = this.moduleModel.getApplicationModel().getDeployer();
            try {
                deployer.increaseServiceRefreshCount();
                this.overrideListeners.values().forEach(listeners -> {
                    for (NotifyListener listener : listeners) {
                        ((OverrideListener)listener).doOverrideIfNecessary();
                    }
                });
            }
            finally {
                deployer.decreaseServiceRefreshCount();
            }
        }

        public Map<URL, Set<NotifyListener>> getOverrideListeners() {
            return this.overrideListeners;
        }
    }

    private class OverrideListener
    implements NotifyListener {
        private final URL subscribeUrl;
        private final Invoker originInvoker;
        private List<Configurator> configurators;

        public OverrideListener(URL subscribeUrl, Invoker originalInvoker) {
            this.subscribeUrl = subscribeUrl;
            this.originInvoker = originalInvoker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void notify(List<URL> urls) {
            if (logger.isDebugEnabled()) {
                logger.debug("original override urls: " + urls);
            }
            List<URL> matchedUrls = this.getMatchedUrls(urls, this.subscribeUrl);
            if (logger.isDebugEnabled()) {
                logger.debug("subscribe url: " + this.subscribeUrl + ", override urls: " + matchedUrls);
            }
            if (matchedUrls.isEmpty()) {
                return;
            }
            this.configurators = Configurator.toConfigurators((List)UrlUtils.classifyUrls(matchedUrls, UrlUtils::isConfigurator)).orElse(this.configurators);
            ApplicationDeployer deployer = this.subscribeUrl.getOrDefaultApplicationModel().getDeployer();
            try {
                deployer.increaseServiceRefreshCount();
                this.doOverrideIfNecessary();
            }
            finally {
                deployer.decreaseServiceRefreshCount();
            }
        }

        public synchronized void doOverrideIfNecessary() {
            Invoker invoker = this.originInvoker instanceof InvokerDelegate ? ((InvokerDelegate)this.originInvoker).getInvoker() : this.originInvoker;
            URL originUrl = RegistryProtocol.this.getProviderUrl(invoker);
            String providerUrlKey = RegistryProtocol.this.getProviderUrlKey(this.originInvoker);
            String registryUrlKey = RegistryProtocol.this.getRegistryUrlKey(this.originInvoker);
            Map exporterMap = (Map)RegistryProtocol.this.bounds.get(providerUrlKey);
            if (exporterMap == null) {
                logger.warn("99-0", "error state, exporterMap can not be null", "", "error state, exporterMap can not be null", (Throwable)new IllegalStateException("error state, exporterMap can not be null"));
                return;
            }
            ExporterChangeableWrapper exporter = (ExporterChangeableWrapper)exporterMap.get(registryUrlKey);
            if (exporter == null) {
                logger.warn("99-0", "unknown error in registry module", "", "error state, exporter should not be null", (Throwable)new IllegalStateException("error state, exporter should not be null"));
                return;
            }
            Invoker exporterInvoker = exporter.getInvoker();
            URL currentUrl = exporterInvoker == null ? null : exporterInvoker.getUrl();
            URL newUrl = RegistryProtocol.getConfiguredInvokerUrl(this.configurators, originUrl);
            newUrl = RegistryProtocol.getConfiguredInvokerUrl(RegistryProtocol.this.getProviderConfigurationListener(originUrl).getConfigurators(), newUrl);
            newUrl = RegistryProtocol.getConfiguredInvokerUrl(((ServiceConfigurationListener)RegistryProtocol.this.serviceConfigurationListeners.get(originUrl.getServiceKey())).getConfigurators(), newUrl);
            if (!newUrl.equals((Object)currentUrl)) {
                if (newUrl.getParameter("need-reexport", true)) {
                    RegistryProtocol.this.reExport(this.originInvoker, newUrl);
                }
                logger.info("exported provider url changed, origin url: " + originUrl + ", old export url: " + currentUrl + ", new export url: " + newUrl);
            }
        }

        private List<URL> getMatchedUrls(List<URL> configuratorUrls, URL currentSubscribe) {
            ArrayList<URL> result = new ArrayList<URL>();
            Iterator<URL> iterator = configuratorUrls.iterator();
            while (iterator.hasNext()) {
                URL url;
                URL overrideUrl = url = iterator.next();
                if (url.getCategory() == null && "override".equals(url.getProtocol())) {
                    overrideUrl = url.addParameter("category", "configurators");
                }
                if (!UrlUtils.isMatch((URL)currentSubscribe, (URL)overrideUrl)) continue;
                result.add(url);
            }
            return result;
        }
    }

    private class ExporterChangeableWrapper<T>
    implements Exporter<T> {
        private final ScheduledExecutorService executor;
        private final Invoker<T> originInvoker;
        private Exporter<T> exporter;
        private URL subscribeUrl;
        private URL registerUrl;
        private NotifyListener notifyListener;
        private final AtomicBoolean registered = new AtomicBoolean(false);

        public ExporterChangeableWrapper(ReferenceCountExporter<T> exporter, Invoker<T> originInvoker) {
            this.exporter = exporter;
            exporter.increaseCount();
            this.originInvoker = originInvoker;
            FrameworkExecutorRepository frameworkExecutorRepository = (FrameworkExecutorRepository)originInvoker.getUrl().getOrDefaultFrameworkModel().getBeanFactory().getBean(FrameworkExecutorRepository.class);
            this.executor = frameworkExecutorRepository.getSharedScheduledExecutor();
        }

        public Invoker<T> getOriginInvoker() {
            return this.originInvoker;
        }

        public Invoker<T> getInvoker() {
            return this.exporter.getInvoker();
        }

        public void setExporter(Exporter<T> exporter) {
            this.exporter = exporter;
        }

        public void register() {
            if (this.registered.compareAndSet(false, true)) {
                URL registryUrl = RegistryProtocol.this.getRegistryUrl(this.originInvoker);
                Registry registry = RegistryProtocol.this.getRegistry(registryUrl);
                RegistryProtocol.register(registry, this.getRegisterUrl());
                ProviderModel providerModel = RegistryProtocol.this.frameworkModel.getServiceRepository().lookupExportedService(this.getRegisterUrl().getServiceKey());
                List statedUrls = providerModel.getStatedUrl();
                statedUrls.stream().filter(u -> u.getRegistryUrl().equals((Object)registryUrl) && u.getProviderUrl().getProtocol().equals(this.getRegisterUrl().getProtocol())).forEach(u -> u.setRegistered(true));
                logger.info("Registered dubbo service " + this.getRegisterUrl().getServiceKey() + " url " + this.getRegisterUrl() + " to registry " + registryUrl);
            }
        }

        public synchronized void unregister() {
            if (this.registered.compareAndSet(true, false)) {
                URL registryUrl = RegistryProtocol.this.getRegistryUrl(this.originInvoker);
                Registry registry = RegistryProtocol.this.getRegistry(registryUrl);
                ProviderModel providerModel = RegistryProtocol.this.frameworkModel.getServiceRepository().lookupExportedService(this.getRegisterUrl().getServiceKey());
                List statedURLs = providerModel.getStatedUrl().stream().filter(u -> u.getRegistryUrl().equals((Object)registryUrl) && u.getProviderUrl().getProtocol().equals(this.getRegisterUrl().getProtocol())).collect(Collectors.toList());
                if (statedURLs.isEmpty() || statedURLs.stream().anyMatch(ProviderModel.RegisterStatedURL::isRegistered)) {
                    try {
                        registry.unregister(this.registerUrl);
                    }
                    catch (Throwable t) {
                        logger.warn("99-0", "unknown error in registry module", "", t.getMessage(), t);
                    }
                }
                try {
                    Map<URL, Set<NotifyListener>> overrideListeners;
                    Set<NotifyListener> listeners;
                    if (this.subscribeUrl != null && (listeners = (overrideListeners = RegistryProtocol.this.getProviderConfigurationListener(this.subscribeUrl).getOverrideListeners()).get(this.subscribeUrl)) != null) {
                        if (listeners.remove(this.notifyListener)) {
                            ApplicationModel applicationModel = ScopeModelUtil.getApplicationModel((ScopeModel)this.registerUrl.getScopeModel());
                            if (((Boolean)applicationModel.modelEnvironment().getConfiguration().convert(Boolean.class, "enable-26x-configuration-listen", (Object)true)).booleanValue() && !registry.isServiceDiscovery()) {
                                registry.unsubscribe(this.subscribeUrl, this.notifyListener);
                            }
                            if (((Boolean)applicationModel.modelEnvironment().getConfiguration().convert(Boolean.class, "enable-configuration-listen", (Object)true)).booleanValue()) {
                                for (ModuleModel moduleModel : applicationModel.getPubModuleModels()) {
                                    if (null == moduleModel.getServiceRepository() || moduleModel.getServiceRepository().getExportedServices().isEmpty()) continue;
                                    ((GovernanceRuleRepository)moduleModel.getExtensionLoader(GovernanceRuleRepository.class).getDefaultExtension()).removeListener(this.subscribeUrl.getServiceKey() + ".configurators", (ConfigurationListener)RegistryProtocol.this.serviceConfigurationListeners.remove(this.subscribeUrl.getServiceKey()));
                                }
                            }
                        }
                        if (listeners.isEmpty()) {
                            overrideListeners.remove(this.subscribeUrl);
                        }
                    }
                }
                catch (Throwable t) {
                    logger.warn("99-0", "unknown error in registry module", "", t.getMessage(), t);
                }
            }
        }

        public synchronized void unexport() {
            String providerUrlKey = RegistryProtocol.this.getProviderUrlKey(this.originInvoker);
            String registryUrlKey = RegistryProtocol.this.getRegistryUrlKey(this.originInvoker);
            Map exporterMap = (Map)RegistryProtocol.this.bounds.remove(providerUrlKey);
            if (exporterMap != null) {
                exporterMap.remove(registryUrlKey);
            }
            this.unregister();
            this.doUnExport();
        }

        public void setRegistered(boolean registered) {
            this.registered.set(registered);
        }

        public boolean isRegistered() {
            return this.registered.get();
        }

        private void doUnExport() {
            try {
                this.exporter.unexport();
            }
            catch (Throwable t) {
                logger.warn("99-0", "unknown error in registry module", "", t.getMessage(), t);
            }
        }

        public void setSubscribeUrl(URL subscribeUrl) {
            this.subscribeUrl = subscribeUrl;
        }

        public void setRegisterUrl(URL registerUrl) {
            this.registerUrl = registerUrl;
        }

        public void setNotifyListener(NotifyListener notifyListener) {
            this.notifyListener = notifyListener;
        }

        public URL getRegisterUrl() {
            return this.registerUrl;
        }
    }

    private static class DestroyableExporter<T>
    implements Exporter<T> {
        private Exporter<T> exporter;

        public DestroyableExporter(Exporter<T> exporter) {
            this.exporter = exporter;
        }

        public Invoker<T> getInvoker() {
            return this.exporter.getInvoker();
        }

        public void unexport() {
            this.exporter.unexport();
        }

        public void register() {
            this.exporter.register();
        }

        public void unregister() {
            this.exporter.unregister();
        }
    }

    private class ServiceConfigurationListener
    extends AbstractConfiguratorListener {
        private URL providerUrl;
        private OverrideListener notifyListener;
        private final ModuleModel moduleModel;

        public ServiceConfigurationListener(ModuleModel moduleModel, URL providerUrl, OverrideListener notifyListener) {
            super(moduleModel);
            this.providerUrl = providerUrl;
            this.notifyListener = notifyListener;
            this.moduleModel = moduleModel;
            if (((Boolean)moduleModel.modelEnvironment().getConfiguration().convert(Boolean.class, "enable-configuration-listen", (Object)true)).booleanValue()) {
                this.initWith(DynamicConfiguration.getRuleKey((URL)providerUrl) + ".configurators");
            }
        }

        private <T> URL overrideUrl(URL providerUrl) {
            return RegistryProtocol.getConfiguredInvokerUrl(this.configurators, providerUrl);
        }

        @Override
        protected void notifyOverrides() {
            ApplicationDeployer deployer = this.moduleModel.getApplicationModel().getDeployer();
            try {
                deployer.increaseServiceRefreshCount();
                this.notifyListener.doOverrideIfNecessary();
            }
            finally {
                deployer.decreaseServiceRefreshCount();
            }
        }
    }

    public static class InvokerDelegate<T>
    extends InvokerWrapper<T> {
        public InvokerDelegate(Invoker<T> invoker, URL url) {
            super(invoker, url);
        }

        public Invoker<T> getInvoker() {
            if (this.invoker instanceof InvokerDelegate) {
                return ((InvokerDelegate)this.invoker).getInvoker();
            }
            return this.invoker;
        }
    }
}

