/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.sofa;

import com.alipay.sofa.registry.client.api.RegistryClient;
import com.alipay.sofa.registry.client.api.RegistryClientConfig;
import com.alipay.sofa.registry.client.api.Subscriber;
import com.alipay.sofa.registry.client.api.model.RegistryType;
import com.alipay.sofa.registry.client.api.model.UserData;
import com.alipay.sofa.registry.client.api.registration.PublisherRegistration;
import com.alipay.sofa.registry.client.api.registration.SubscriberRegistration;
import com.alipay.sofa.registry.client.provider.DefaultRegistryClient;
import com.alipay.sofa.registry.client.provider.DefaultRegistryClientConfig;
import com.alipay.sofa.registry.client.provider.DefaultRegistryClientConfigBuilder;
import com.alipay.sofa.registry.core.model.ScopeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.ConfigUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.support.FailbackRegistry;

public class SofaRegistry
extends FailbackRegistry {
    private final Map<String, Subscriber> subscribers = new ConcurrentHashMap<String, Subscriber>();
    private RegistryClient registryClient;
    private int waitAddressTimeout;

    public SofaRegistry(URL url) {
        super(url);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Build sofa registry by url:" + url);
        }
        this.registryClient = this.buildClient(url);
        this.waitAddressTimeout = Integer.parseInt(ConfigUtils.getProperty((String)"rpc.reference.address.wait.time", (String)"5000"));
    }

    protected RegistryClient buildClient(URL url) {
        DefaultRegistryClientConfig config = DefaultRegistryClientConfigBuilder.start().setDataCenter("DefaultDataCenter").setZone("DEFAULT_ZONE").setRegistryEndpoint(url.getHost()).setRegistryEndpointPort(url.getPort()).build();
        DefaultRegistryClient registryClient = new DefaultRegistryClient((RegistryClientConfig)config);
        registryClient.init();
        return registryClient;
    }

    public boolean isAvailable() {
        return true;
    }

    public void doRegister(URL url) {
        if (!url.getParameter("register", true) || "consumer".equals(url.getProtocol())) {
            return;
        }
        String serviceName = this.buildServiceName(url);
        String serviceData = url.toFullString();
        PublisherRegistration registration = new PublisherRegistration(serviceName);
        this.addAttributesForPub(registration);
        this.registryClient.register(registration, new String[]{serviceData});
    }

    protected void addAttributesForPub(PublisherRegistration publisherRegistration) {
        publisherRegistration.setGroup("SOFA");
    }

    public void doUnregister(URL url) {
        if (!url.getParameter("register", true) || "consumer".equals(url.getProtocol())) {
            return;
        }
        String serviceName = this.buildServiceName(url);
        this.registryClient.unregister(serviceName, "SOFA", RegistryType.PUBLISHER);
    }

    public void doSubscribe(URL url, NotifyListener listener) {
        if (!url.getParameter("subscribe", true) || "provider".equals(url.getProtocol())) {
            return;
        }
        String serviceName = this.buildServiceName(url);
        Subscriber listSubscriber = this.subscribers.get(serviceName);
        if (listSubscriber != null) {
            this.logger.warn("Service name [" + serviceName + "] have bean registered in SOFARegistry.");
            CountDownLatch countDownLatch = new CountDownLatch(1);
            this.handleRegistryData(listSubscriber.peekData(), listener, countDownLatch);
            this.waitAddress(serviceName, countDownLatch);
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        SubscriberRegistration subscriberRegistration = new SubscriberRegistration(serviceName, (dataId, data) -> {
            this.printAddressData(dataId, data);
            this.handleRegistryData(data, listener, latch);
        });
        this.addAttributesForSub(subscriberRegistration);
        listSubscriber = this.registryClient.register(subscriberRegistration);
        this.subscribers.put(serviceName, listSubscriber);
        this.waitAddress(serviceName, latch);
    }

    private void waitAddress(String serviceName, CountDownLatch countDownLatch) {
        try {
            if (!countDownLatch.await(this.waitAddressTimeout, TimeUnit.MILLISECONDS)) {
                this.logger.warn("Subscribe data failed by dataId " + serviceName);
            }
        }
        catch (Exception e) {
            this.logger.error("Error when wait Address!", (Throwable)e);
        }
    }

    public void doUnsubscribe(URL url, NotifyListener listener) {
        if (!url.getParameter("subscribe", true) || "provider".equals(url.getProtocol())) {
            return;
        }
        String serviceName = this.buildServiceName(url);
        this.registryClient.unregister(serviceName, "SOFA", RegistryType.SUBSCRIBER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRegistryData(UserData data, NotifyListener notifyListener, CountDownLatch latch) {
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            if (null != data) {
                List<String> datas = this.flatUserData(data);
                for (String serviceUrl : datas) {
                    URL url = URL.valueOf((String)serviceUrl);
                    String serverApplication = url.getParameter("application");
                    if (StringUtils.isNotEmpty((String)serverApplication)) {
                        url = url.addParameter("dstApp", serverApplication);
                    }
                    urls.add(url);
                }
            }
            notifyListener.notify(urls);
        }
        finally {
            latch.countDown();
        }
    }

    private String buildServiceName(URL url) {
        String group;
        StringBuilder buf = new StringBuilder();
        buf.append(url.getServiceInterface());
        String version = url.getParameter("version");
        if (StringUtils.isNotEmpty((String)version)) {
            buf.append(":").append(version);
        }
        if (StringUtils.isNotEmpty((String)(group = url.getParameter("group")))) {
            buf.append(":").append(group);
        }
        buf.append("@").append("dubbo");
        return buf.toString();
    }

    protected void printAddressData(String dataId, UserData userData) {
        List<String> datas = userData == null ? new ArrayList<String>(0) : this.flatUserData(userData);
        StringBuilder sb = new StringBuilder();
        for (String provider : datas) {
            sb.append("  >>> ").append(provider).append("\n");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Receive updated RPC service addresses: service[" + dataId + "]\n  .Available target addresses size [" + datas.size() + "]\n" + sb.toString());
        }
    }

    protected void addAttributesForSub(SubscriberRegistration subscriberRegistration) {
        subscriberRegistration.setGroup("SOFA");
        subscriberRegistration.setScopeEnum(ScopeEnum.global);
    }

    protected List<String> flatUserData(UserData userData) {
        ArrayList<String> result = new ArrayList<String>();
        Map zoneData = userData.getZoneData();
        for (Map.Entry entry : zoneData.entrySet()) {
            result.addAll((Collection)entry.getValue());
        }
        return result;
    }
}

