/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.zookeeper;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.function.ThrowableConsumer;
import org.apache.dubbo.common.function.ThrowableFunction;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.registry.client.AbstractServiceDiscovery;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.zookeeper.ZookeeperInstance;
import org.apache.dubbo.registry.zookeeper.ZookeeperServiceDiscoveryChangeWatcher;
import org.apache.dubbo.registry.zookeeper.util.CuratorFrameworkUtils;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.zookeeper.KeeperException;

public class ZookeeperServiceDiscovery
extends AbstractServiceDiscovery {
    private final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(((Object)((Object)this)).getClass());
    public static final String DEFAULT_GROUP = "/services";
    private final CuratorFramework curatorFramework;
    private final String rootPath;
    private final ServiceDiscovery<ZookeeperInstance> serviceDiscovery;
    private final Map<String, ZookeeperServiceDiscoveryChangeWatcher> watcherCaches = new ConcurrentHashMap<String, ZookeeperServiceDiscoveryChangeWatcher>();

    public ZookeeperServiceDiscovery(ApplicationModel applicationModel, URL registryURL) {
        super(applicationModel, registryURL);
        try {
            this.curatorFramework = CuratorFrameworkUtils.buildCuratorFramework(registryURL, this);
            this.rootPath = CuratorFrameworkUtils.getRootPath(registryURL);
            this.serviceDiscovery = CuratorFrameworkUtils.buildServiceDiscovery(this.curatorFramework, this.rootPath);
            this.serviceDiscovery.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("Create zookeeper service discovery failed.", e);
        }
    }

    public void doDestroy() throws Exception {
        this.serviceDiscovery.close();
        this.curatorFramework.close();
        this.watcherCaches.clear();
    }

    public void doRegister(ServiceInstance serviceInstance) {
        try {
            this.serviceDiscovery.registerService(CuratorFrameworkUtils.build(serviceInstance));
        }
        catch (Exception e) {
            throw new RpcException(9, "Failed register instance " + serviceInstance.toString(), (Throwable)e);
        }
    }

    public void doUnregister(ServiceInstance serviceInstance) throws RuntimeException {
        if (serviceInstance != null) {
            this.doInServiceRegistry((ThrowableConsumer<ServiceDiscovery>)((ThrowableConsumer)serviceDiscovery -> serviceDiscovery.unregisterService(CuratorFrameworkUtils.build(serviceInstance))));
        }
    }

    public Set<String> getServices() {
        return (Set)this.doInServiceDiscovery(s -> new LinkedHashSet(s.queryForNames()));
    }

    public List<ServiceInstance> getInstances(String serviceName) throws NullPointerException {
        return (List)this.doInServiceDiscovery(s -> CuratorFrameworkUtils.build(this.registryURL, s.queryForInstances(serviceName)));
    }

    public void addServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws NullPointerException, IllegalArgumentException {
        if (!this.instanceListeners.add(listener)) {
            return;
        }
        listener.getServiceNames().forEach(serviceName -> this.registerServiceWatcher((String)serviceName, listener));
    }

    public void removeServiceInstancesChangedListener(ServiceInstancesChangedListener listener) throws IllegalArgumentException {
        listener.getServiceNames().forEach(serviceName -> {
            String servicePath = this.buildServicePath((String)serviceName);
            ZookeeperServiceDiscoveryChangeWatcher watcher = this.watcherCaches.get(servicePath);
            if (watcher != null) {
                watcher.getListeners().remove(listener);
                if (watcher.getListeners().isEmpty()) {
                    watcher.stopWatching();
                    this.watcherCaches.remove(servicePath);
                }
            }
        });
    }

    private void doInServiceRegistry(ThrowableConsumer<ServiceDiscovery> consumer) {
        ThrowableConsumer.execute(this.serviceDiscovery, s -> consumer.accept(s));
    }

    private <R> R doInServiceDiscovery(ThrowableFunction<ServiceDiscovery, R> function) {
        return (R)ThrowableFunction.execute(this.serviceDiscovery, function);
    }

    protected void registerServiceWatcher(String serviceName, ServiceInstancesChangedListener listener) {
        String path = this.buildServicePath(serviceName);
        try {
            this.curatorFramework.create().creatingParentsIfNeeded().forPath(path);
        }
        catch (KeeperException.NodeExistsException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Throwable)e);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("registerServiceWatcher create path=" + path + " fail.", e);
        }
        CountDownLatch latch = new CountDownLatch(1);
        ZookeeperServiceDiscoveryChangeWatcher watcher = this.watcherCaches.computeIfAbsent(path, key -> {
            ZookeeperServiceDiscoveryChangeWatcher tmpWatcher = new ZookeeperServiceDiscoveryChangeWatcher(this, serviceName, path, latch);
            try {
                ((BackgroundPathable)this.curatorFramework.getChildren().usingWatcher((CuratorWatcher)tmpWatcher)).forPath(path);
            }
            catch (KeeperException.NoNodeException e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("1-35", "", "", e.getMessage());
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            return tmpWatcher;
        });
        watcher.addListener(listener);
        listener.onEvent(new ServiceInstancesChangedEvent(serviceName, this.getInstances(serviceName)));
        latch.countDown();
    }

    public void recover() {
        this.watcherCaches.forEach((path, watcher) -> {
            CountDownLatch latch = new CountDownLatch(1);
            Set<ServiceInstancesChangedListener> listeners = watcher.getListeners();
            try {
                watcher.setLatch(latch);
                ((BackgroundPathable)this.curatorFramework.getChildren().usingWatcher((CuratorWatcher)watcher)).forPath(path);
            }
            catch (Exception e) {
                this.logger.error("1-35", "", "", "Trying to recover from new zkClient session failed, path is " + path + ", error msg: " + e.getMessage());
            }
            List<ServiceInstance> instances = this.getInstances(watcher.getServiceName());
            for (ServiceInstancesChangedListener listener : listeners) {
                listener.onEvent(new ServiceInstancesChangedEvent(watcher.getServiceName(), instances));
            }
            latch.countDown();
        });
    }

    public void reRegisterWatcher(ZookeeperServiceDiscoveryChangeWatcher watcher) throws Exception {
        ((BackgroundPathable)this.curatorFramework.getChildren().usingWatcher((CuratorWatcher)watcher)).forPath(watcher.getPath());
    }

    private String buildServicePath(String serviceName) {
        return this.rootPath + "/" + serviceName;
    }
}

