/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.zookeeper;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.dubbo.common.threadpool.manager.FrameworkExecutorRepository;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.registry.RegistryNotifier;
import org.apache.dubbo.registry.client.ServiceInstance;
import org.apache.dubbo.registry.client.event.ServiceInstancesChangedEvent;
import org.apache.dubbo.registry.client.event.listener.ServiceInstancesChangedListener;
import org.apache.dubbo.registry.zookeeper.ZookeeperServiceDiscovery;
import org.apache.dubbo.rpc.model.ScopeModel;
import org.apache.dubbo.rpc.model.ScopeModelUtil;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;

public class ZookeeperServiceDiscoveryChangeWatcher
implements CuratorWatcher {
    private Set<ServiceInstancesChangedListener> listeners = new ConcurrentHashSet();
    private final ZookeeperServiceDiscovery zookeeperServiceDiscovery;
    private final RegistryNotifier notifier;
    private volatile boolean keepWatching = true;
    private final String serviceName;
    private final String path;
    private CountDownLatch latch;

    public ZookeeperServiceDiscoveryChangeWatcher(ZookeeperServiceDiscovery zookeeperServiceDiscovery, String serviceName, String path, CountDownLatch latch) {
        this.zookeeperServiceDiscovery = zookeeperServiceDiscovery;
        this.serviceName = serviceName;
        this.path = path;
        this.latch = latch;
        this.notifier = new RegistryNotifier(zookeeperServiceDiscovery.getUrl(), zookeeperServiceDiscovery.getDelay(), ((FrameworkExecutorRepository)ScopeModelUtil.getFrameworkModel((ScopeModel)zookeeperServiceDiscovery.getUrl().getScopeModel()).getBeanFactory().getBean(FrameworkExecutorRepository.class)).getServiceDiscoveryAddressNotificationExecutor()){

            protected void doNotify(Object rawAddresses) {
                ZookeeperServiceDiscoveryChangeWatcher.this.listeners.forEach(listener -> listener.onEvent((ServiceInstancesChangedEvent)rawAddresses));
            }
        };
    }

    public void process(WatchedEvent event) throws Exception {
        try {
            this.latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Watcher.Event.EventType eventType = event.getType();
        if ((Watcher.Event.EventType.NodeChildrenChanged.equals((Object)eventType) || Watcher.Event.EventType.NodeDataChanged.equals((Object)eventType)) && this.shouldKeepWatching()) {
            this.zookeeperServiceDiscovery.reRegisterWatcher(this);
            List<ServiceInstance> instanceList = this.zookeeperServiceDiscovery.getInstances(this.serviceName);
            this.notifier.notify((Object)new ServiceInstancesChangedEvent(this.serviceName, instanceList));
        }
    }

    public String getPath() {
        return this.path;
    }

    public void addListener(ServiceInstancesChangedListener listener) {
        this.listeners.add(listener);
    }

    public Set<ServiceInstancesChangedListener> getListeners() {
        return this.listeners;
    }

    public boolean shouldKeepWatching() {
        return this.keepWatching;
    }

    public void stopWatching() {
        this.keepWatching = false;
    }

    public void setLatch(CountDownLatch latch) {
        this.latch = latch;
    }

    public String getServiceName() {
        return this.serviceName;
    }
}

