/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.dispatcher.all2;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.timer.HashedWheelTimer;
import org.apache.dubbo.common.timer.Timer;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.ExecutionException;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.transport.dispatcher.ChannelEventRunnable;
import org.apache.dubbo.remoting.transport.dispatcher.all.AllChannelHandler;

public class AllChannelHandler2
extends AllChannelHandler {
    public static final Timer TIME_OUT_TIMER = new HashedWheelTimer((ThreadFactory)new NamedThreadFactory("dubbo-server-future-timeout", true), 30L, TimeUnit.MILLISECONDS);

    public AllChannelHandler2(ChannelHandler handler, URL url) {
        super(handler, url);
    }

    @Override
    public void received(Channel channel, Object message) throws RemotingException {
        ExecutorService executor = this.getPreferredExecutorService(message);
        try {
            Future<?> future = executor.submit(new ChannelEventRunnable(channel, this.handler, ChannelEventRunnable.ChannelState.RECEIVED, message));
            long timeout = this.url.getParameter("timeout", 1000) + 90;
            TIME_OUT_TIMER.newTimeout(t -> {
                if (!future.isDone() && !future.isCancelled()) {
                    try {
                        future.cancel(true);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }, timeout, TimeUnit.MILLISECONDS);
        }
        catch (Throwable t2) {
            if (message instanceof Request && t2 instanceof RejectedExecutionException) {
                this.sendFeedback(channel, (Request)message, t2);
                return;
            }
            throw new ExecutionException(message, channel, this.getClass() + " error when process received event .", t2);
        }
    }
}

