/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting;

import java.util.List;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.zookeeper.ZookeeperTransporter;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ModuleModel;
import org.apache.dubbo.rpc.model.ScopeModelInitializer;

public class RemotingScopeModelInitializer
implements ScopeModelInitializer {
    private static final Logger logger = LoggerFactory.getLogger(RemotingScopeModelInitializer.class);

    public void initializeFrameworkModel(FrameworkModel frameworkModel) {
    }

    public void initializeApplicationModel(ApplicationModel applicationModel) {
        applicationModel.addDestroyListener(m -> {
            try {
                List transporters = applicationModel.getExtensionLoader(ZookeeperTransporter.class).getLoadedExtensionInstances();
                for (ZookeeperTransporter zkTransporter : transporters) {
                    zkTransporter.destroy();
                }
            }
            catch (Exception e) {
                logger.error("Error encountered while destroying ZookeeperTransporter: " + e.getMessage(), (Throwable)e);
            }
        });
    }

    public void initializeModuleModel(ModuleModel moduleModel) {
    }
}

