/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api.pu;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.api.WireProtocol;
import org.apache.dubbo.remoting.transport.AbstractServer;

public abstract class AbstractPortUnificationServer
extends AbstractServer {
    private final List<WireProtocol> protocols;
    private final Map<String, URL> supportedUrls = new ConcurrentHashMap<String, URL>();
    private final Map<String, ChannelHandler> supportedHandlers = new ConcurrentHashMap<String, ChannelHandler>();

    public AbstractPortUnificationServer(URL url, ChannelHandler handler) throws RemotingException {
        super(url, handler);
        this.protocols = url.getOrDefaultFrameworkModel().getExtensionLoader(WireProtocol.class).getActivateExtension(url, new String[0]);
    }

    public List<WireProtocol> getProtocols() {
        return this.protocols;
    }

    public void addSupportedProtocol(URL url, ChannelHandler handler) {
        this.supportedUrls.put(url.getProtocol(), url);
        this.supportedHandlers.put(url.getProtocol(), handler);
    }

    protected Map<String, URL> getSupportedUrls() {
        return this.supportedUrls;
    }

    public Map<String, ChannelHandler> getSupportedHandlers() {
        return this.supportedHandlers;
    }
}

