/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.dubbo.remoting.api.ProtocolDetector;
import org.apache.dubbo.remoting.buffer.ChannelBuffer;

public abstract class AbstractHttpProtocolDetector
implements ProtocolDetector {
    protected int empty = 32;
    protected static String SIMPLE_HTTP = "XXX HTTP/1";
    protected static final List<HttpMethod> QOS_HTTP_METHOD = Arrays.asList(HttpMethod.GET, HttpMethod.POST);
    protected static final List<HttpMethod> HTTP_METHODS = Arrays.asList(HttpMethod.GET, HttpMethod.POST, HttpMethod.DELETE, HttpMethod.PUT, HttpMethod.HEAD, HttpMethod.PATCH, HttpMethod.OPTIONS, HttpMethod.TRACE);

    protected static char[][] getHttpMethodsPrefix(int length, List<HttpMethod> httpMethods) {
        if (0 >= length || length > 3) {
            throw new IllegalArgumentException("Current substring length is beyond Http methods length");
        }
        ArrayList<char[]> prefix = new ArrayList<char[]>();
        for (HttpMethod httpMethod : httpMethods) {
            prefix.add(httpMethod.getValue().substring(0, length).toCharArray());
        }
        return (char[][])prefix.toArray((T[])new char[0][]);
    }

    protected static char[][] getHttpMethodsPrefix() {
        return AbstractHttpProtocolDetector.getHttpMethodsPrefix(3, HTTP_METHODS);
    }

    protected static char[][] getQOSHttpMethodsPrefix() {
        return AbstractHttpProtocolDetector.getHttpMethodsPrefix(3, QOS_HTTP_METHOD);
    }

    protected boolean isQosRequestURL(String requestUrl) {
        if (requestUrl == null) {
            return false;
        }
        String[] split = requestUrl.split("/");
        return split.length <= 3;
    }

    protected String splitAndGetFirst(String str) {
        return this.splitAndGet(str, 1);
    }

    protected String splitAndGet(String str, int index) {
        if (str == null) {
            return null;
        }
        String[] split = str.split("/");
        if (split.length - 1 < index) {
            return null;
        }
        return split[index];
    }

    protected String readRequestLine(ChannelBuffer buffer) {
        int read;
        int firstEmptyIndex = 0;
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            int read2 = this.getByteByIndex(buffer, i);
            if (read2 != this.empty) continue;
            firstEmptyIndex = i;
            break;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = firstEmptyIndex + 1; i < Integer.MAX_VALUE && (read = this.getByteByIndex(buffer, i)) != this.empty; ++i) {
            stringBuilder.append((char)read);
        }
        return stringBuilder.toString();
    }

    public static enum HttpMethod {
        GET("GET"),
        HEAD("HEAD"),
        POST("POST"),
        PUT("PUT"),
        PATCH("PATCH"),
        DELETE("DELETE"),
        OPTIONS("OPTIONS"),
        TRACE("TRACE");

        private String value;

        private HttpMethod(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

