/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api;

import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.remoting.buffer.ChannelBuffer;

public interface ProtocolDetector {
    public Result detect(ChannelBuffer var1);

    default public int getByteByIndex(ChannelBuffer buffer, int index) {
        return buffer.getByte(buffer.readerIndex() + index);
    }

    default public boolean prefixMatch(char[][] prefixes, ChannelBuffer buffer, int length) {
        int[] ints = new int[length];
        for (int i = 0; i < length; ++i) {
            ints[i] = this.getByteByIndex(buffer, i);
        }
        for (char[] prefix : prefixes) {
            boolean matched = true;
            for (int j = 0; j < length; ++j) {
                if (prefix[j] == ints[j]) continue;
                matched = false;
                break;
            }
            if (!matched) continue;
            return true;
        }
        return false;
    }

    public static enum Flag {
        RECOGNIZED,
        UNRECOGNIZED,
        NEED_MORE_DATA;

    }

    public static class Result {
        private final Flag flag;
        private final Map<String, String> detectContext = new HashMap<String, String>(4);

        private Result(Flag flag) {
            this.flag = flag;
        }

        public void setAttribute(String key, String value) {
            this.detectContext.put(key, value);
        }

        public String getAttribute(String key) {
            return this.detectContext.get(key);
        }

        public void removeAttribute(String key) {
            this.detectContext.remove(key);
        }

        public Flag flag() {
            return this.flag;
        }

        public static Result recognized() {
            return new Result(Flag.RECOGNIZED);
        }

        public static Result unrecognized() {
            return new Result(Flag.UNRECOGNIZED);
        }

        public static Result needMoreData() {
            return new Result(Flag.NEED_MORE_DATA);
        }
    }
}

