/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http.tomcat;

import java.io.File;
import javax.servlet.Servlet;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.http.HttpHandler;
import org.apache.dubbo.remoting.http.servlet.DispatcherServlet;
import org.apache.dubbo.remoting.http.servlet.ServletManager;
import org.apache.dubbo.remoting.http.support.AbstractHttpServer;

public class TomcatHttpServer
extends AbstractHttpServer {
    private static final Logger logger = LoggerFactory.getLogger(TomcatHttpServer.class);
    private final Tomcat tomcat;
    private final URL url;

    public TomcatHttpServer(URL url, HttpHandler handler) {
        super(url, handler);
        this.url = url;
        DispatcherServlet.addHttpHandler(url.getPort(), handler);
        String baseDir = new File(System.getProperty("java.io.tmpdir")).getAbsolutePath();
        this.tomcat = new Tomcat();
        Connector connector = this.tomcat.getConnector();
        connector.setPort(url.getPort());
        connector.setProperty("maxThreads", String.valueOf(url.getParameter("threads", 200)));
        connector.setProperty("maxConnections", String.valueOf(url.getParameter("accepts", -1)));
        connector.setProperty("URIEncoding", "UTF-8");
        connector.setProperty("connectionTimeout", "60000");
        connector.setProperty("maxKeepAliveRequests", "-1");
        this.tomcat.setBaseDir(baseDir);
        this.tomcat.setPort(url.getPort());
        Context context = this.tomcat.addContext("/", baseDir);
        Tomcat.addServlet((Context)context, (String)"dispatcher", (Servlet)new DispatcherServlet());
        context.addServletMappingDecoded("/*", "dispatcher");
        ServletManager.getInstance().addServletContext(url.getPort(), context.getServletContext());
        System.setProperty("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE", "true");
        try {
            this.tomcat.start();
        }
        catch (LifecycleException e) {
            throw new IllegalStateException("Failed to start tomcat server at " + url.getAddress(), e);
        }
    }

    @Override
    public void close() {
        super.close();
        ServletManager.getInstance().removeServletContext(this.url.getPort());
        try {
            this.tomcat.stop();
            this.tomcat.destroy();
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }
}

