/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message;

import java.io.InputStream;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.ListeningDecoder;

public class DefaultListeningDecoder
implements ListeningDecoder {
    private final HttpMessageCodec httpMessageCodec;
    private final Class<?>[] targetTypes;
    private ListeningDecoder.Listener listener;

    public DefaultListeningDecoder(HttpMessageCodec httpMessageCodec, Class<?>[] targetTypes) {
        this.httpMessageCodec = httpMessageCodec;
        this.targetTypes = targetTypes;
    }

    @Override
    public void setListener(ListeningDecoder.Listener listener) {
        this.listener = listener;
    }

    @Override
    public void decode(InputStream inputStream) {
        Object[] decode = this.httpMessageCodec.decode(inputStream, this.targetTypes);
        this.listener.onMessage(decode);
    }

    @Override
    public void close() {
        this.listener.onClose();
    }
}

