/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.dubbo.common.extension.ExtensionScope;
import org.apache.dubbo.common.extension.SPI;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.exception.EncodeException;
import org.apache.dubbo.remoting.http12.message.MediaType;

@SPI(scope=ExtensionScope.FRAMEWORK)
public interface HttpMessageCodec {
    public void encode(OutputStream var1, Object var2) throws EncodeException;

    default public void encode(OutputStream outputStream, Object[] data) throws EncodeException {
        this.encode(outputStream, data == null || data.length == 0 ? null : data[0]);
    }

    public Object decode(InputStream var1, Class<?> var2) throws DecodeException;

    default public Object[] decode(InputStream inputStream, Class<?>[] targetTypes) throws DecodeException {
        return new Object[]{this.decode(inputStream, targetTypes == null || targetTypes.length == 0 ? null : targetTypes[0])};
    }

    public MediaType contentType();

    default public boolean support(String contentType) {
        MediaType mediaType = this.contentType();
        return mediaType.getName().startsWith(contentType);
    }
}

