/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;

public class MediaType {
    public static final MediaType ALL_VALUE = new MediaType("*", "*");
    public static final MediaType APPLICATION_JSON_VALUE = new MediaType("application", "json");
    public static final MediaType TEXT_EVENT_STREAM_VALUE = new MediaType("text", "event-stream");
    private final String name;
    private final String type;
    private final String subType;
    private final Charset charset;

    public MediaType(String type, String subType) {
        this(type, subType, Collections.singletonMap("charset", "UTF-8"));
    }

    public MediaType(String type, String subType, Map<String, String> parameters) {
        this.type = type;
        this.subType = subType;
        this.name = type + "/" + subType;
        this.charset = Charset.forName(parameters.getOrDefault("charset", "UTF-8"));
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public Charset getCharset() {
        return this.charset;
    }
}

