/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12;

import java.util.List;
import java.util.Map;
import org.apache.dubbo.remoting.http12.CustomizableHttpChannelObserver;
import org.apache.dubbo.remoting.http12.ErrorResponse;
import org.apache.dubbo.remoting.http12.ErrorResponseCustomizer;
import org.apache.dubbo.remoting.http12.HeadersCustomizer;
import org.apache.dubbo.remoting.http12.HttpChannel;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpOutputMessage;
import org.apache.dubbo.remoting.http12.HttpResult;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.TrailersCustomizer;
import org.apache.dubbo.remoting.http12.exception.EncodeException;
import org.apache.dubbo.remoting.http12.exception.HttpResultPayloadException;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.remoting.http12.message.HttpMessageEncoder;

public abstract class AbstractServerHttpChannelObserver
implements CustomizableHttpChannelObserver<Object> {
    private HeadersCustomizer headersCustomizer = HeadersCustomizer.NO_OP;
    private TrailersCustomizer trailersCustomizer = TrailersCustomizer.NO_OP;
    private ErrorResponseCustomizer errorResponseCustomizer = ErrorResponseCustomizer.NO_OP;
    private final HttpChannel httpChannel;
    private boolean headerSent;
    private HttpMessageEncoder responseEncoder;

    public AbstractServerHttpChannelObserver(HttpChannel httpChannel) {
        this.httpChannel = httpChannel;
    }

    public void setResponseEncoder(HttpMessageEncoder responseEncoder) {
        this.responseEncoder = responseEncoder;
    }

    public HttpMessageEncoder getResponseEncoder() {
        return this.responseEncoder;
    }

    @Override
    public void setHeadersCustomizer(HeadersCustomizer headersCustomizer) {
        this.headersCustomizer = headersCustomizer;
    }

    @Override
    public void setTrailersCustomizer(TrailersCustomizer trailersCustomizer) {
        this.trailersCustomizer = trailersCustomizer;
    }

    @Override
    public void setErrorResponseCustomizer(ErrorResponseCustomizer errorResponseCustomizer) {
        this.errorResponseCustomizer = errorResponseCustomizer;
    }

    protected HeadersCustomizer getHeadersCustomizer() {
        return this.headersCustomizer;
    }

    protected TrailersCustomizer getTrailersCustomizer() {
        return this.trailersCustomizer;
    }

    public void onNext(Object data) {
        try {
            if (data instanceof HttpResult) {
                HttpResult result = (HttpResult)data;
                if (!this.headerSent) {
                    this.doSendHeaders(String.valueOf(result.getStatus()), result.getHeaders());
                }
                data = result.getBody();
            } else if (!this.headerSent) {
                this.doSendHeaders(HttpStatus.OK.getStatusString(), null);
            }
            HttpOutputMessage outputMessage = this.encodeHttpOutputMessage(data);
            this.preOutputMessage(outputMessage);
            this.responseEncoder.encode(outputMessage.getBody(), data);
            this.getHttpChannel().writeMessage(outputMessage);
            this.postOutputMessage(outputMessage);
        }
        catch (Throwable e) {
            this.onError(e);
        }
    }

    protected void preOutputMessage(HttpOutputMessage outputMessage) throws Throwable {
    }

    protected void postOutputMessage(HttpOutputMessage outputMessage) throws Throwable {
    }

    protected abstract HttpMetadata encodeHttpMetadata();

    protected HttpOutputMessage encodeHttpOutputMessage(Object data) {
        return this.getHttpChannel().newOutputMessage();
    }

    protected HttpMetadata encodeTrailers(Throwable throwable) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable throwable) {
        if (throwable instanceof HttpResultPayloadException) {
            this.onNext(((HttpResultPayloadException)throwable).getResult());
            return;
        }
        int httpStatusCode = HttpStatus.INTERNAL_SERVER_ERROR.getCode();
        if (throwable instanceof HttpStatusException) {
            httpStatusCode = ((HttpStatusException)throwable).getStatusCode();
        }
        if (!this.headerSent) {
            this.doSendHeaders(String.valueOf(httpStatusCode), null);
        }
        try {
            ErrorResponse errorResponse = new ErrorResponse();
            errorResponse.setStatus(String.valueOf(httpStatusCode));
            errorResponse.setMessage(throwable.getMessage());
            this.errorResponseCustomizer.accept(errorResponse, throwable);
            HttpOutputMessage httpOutputMessage = this.encodeHttpOutputMessage(errorResponse);
            this.responseEncoder.encode(httpOutputMessage.getBody(), errorResponse);
            this.getHttpChannel().writeMessage(httpOutputMessage);
        }
        catch (Throwable ex) {
            throwable = new EncodeException(ex);
        }
        finally {
            this.doOnCompleted(throwable);
        }
    }

    public void onCompleted() {
        this.doOnCompleted(null);
    }

    @Override
    public HttpChannel getHttpChannel() {
        return this.httpChannel;
    }

    private void doSendHeaders(String statusCode, Map<String, List<String>> additionalHeaders) {
        HttpMetadata httpMetadata = this.encodeHttpMetadata();
        HttpHeaders headers = httpMetadata.headers();
        headers.set(HttpHeaderNames.STATUS.getName(), statusCode);
        headers.set(HttpHeaderNames.CONTENT_TYPE.getName(), this.responseEncoder.contentType());
        this.headersCustomizer.accept(headers);
        if (additionalHeaders != null) {
            headers.putAll((Map<? extends String, ? extends List<String>>)additionalHeaders);
        }
        this.getHttpChannel().writeHeader(httpMetadata);
        this.headerSent = true;
    }

    protected void doOnCompleted(Throwable throwable) {
        HttpMetadata httpMetadata = this.encodeTrailers(throwable);
        if (httpMetadata == null) {
            return;
        }
        this.trailersCustomizer.accept(httpMetadata.headers(), throwable);
        this.getHttpChannel().writeHeader(httpMetadata);
    }
}

