/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.exception.EncodeException;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.MediaType;

public class BinaryCodec
implements HttpMessageCodec {
    @Override
    public void encode(OutputStream os, Object data, Charset charset) throws EncodeException {
        if (data == null) {
            return;
        }
        try {
            if (data instanceof byte[]) {
                os.write((byte[])data);
                return;
            }
        }
        catch (IOException e) {
            throw new EncodeException(e);
        }
        throw new EncodeException("'application/octet-stream' media-type only supports byte[] return type.");
    }

    @Override
    public Object decode(InputStream is, Class<?> targetType, Charset charset) throws DecodeException {
        try {
            return StreamUtils.readBytes((InputStream)is);
        }
        catch (Exception e) {
            throw new DecodeException(e);
        }
    }

    @Override
    public MediaType mediaType() {
        return MediaType.APPLICATION_OCTET_STREAM;
    }
}

