/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message.codec;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.convert.ConverterUtil;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.exception.EncodeException;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.MediaType;

public class UrlEncodeFormCodec
implements HttpMessageCodec {
    private final ConverterUtil converterUtil;

    public UrlEncodeFormCodec(ConverterUtil converterUtil) {
        this.converterUtil = converterUtil;
    }

    @Override
    public void encode(OutputStream outputStream, Object data, Charset charset) throws EncodeException {
        block6: {
            try {
                if (data instanceof String) {
                    outputStream.write(((String)data).getBytes());
                    break block6;
                }
                if (data instanceof Map) {
                    StringBuilder toWrite = new StringBuilder();
                    for (Map.Entry e : ((Map)data).entrySet()) {
                        String k = e.getKey().toString();
                        String v = e.getValue().toString();
                        toWrite.append(k).append("=").append(URLEncoder.encode(v, StandardCharsets.UTF_8.name())).append("&");
                    }
                    if (toWrite.length() > 1) {
                        outputStream.write(toWrite.substring(0, toWrite.length() - 1).getBytes(charset));
                    }
                    break block6;
                }
                throw new EncodeException("UrlEncodeFrom media-type only supports String or Map as return type.");
            }
            catch (Exception e) {
                throw new EncodeException(e);
            }
        }
    }

    @Override
    public Object decode(InputStream inputStream, Class<?> targetType, Charset charset) throws DecodeException {
        Object[] res = this.decode(inputStream, new Class[]{targetType}, charset);
        return res.length > 1 ? res : res[0];
    }

    @Override
    public Object[] decode(InputStream inputStream, Class<?>[] targetTypes, Charset charset) throws DecodeException {
        try {
            boolean toMap;
            if (targetTypes.length == 1 && targetTypes[0].isAssignableFrom(HashMap.class)) {
                toMap = true;
            } else if (Arrays.stream(targetTypes).allMatch(clz -> String.class.isAssignableFrom((Class<?>)clz) || Number.class.isAssignableFrom((Class<?>)clz))) {
                toMap = false;
            } else {
                throw new DecodeException("For x-www-form-urlencoded MIME type, please use Map/String/base-types as method param.");
            }
            String decoded = URLDecoder.decode(StreamUtils.toString((InputStream)inputStream, (Charset)charset), StandardCharsets.UTF_8.name()).trim();
            Map<String, Object> res = this.toMap(decoded, targetTypes, toMap);
            if (toMap) {
                return new Object[]{res};
            }
            return res.values().toArray();
        }
        catch (Exception e) {
            throw new DecodeException(e);
        }
    }

    private Map<String, Object> toMap(String formString, Class<?>[] targetTypes, boolean toMap) {
        HashMap<String, Object> res = new HashMap<String, Object>(1);
        String[] parts = formString.split("&");
        for (int i = 0; i < parts.length; ++i) {
            String pair = parts[i];
            int index = pair.indexOf("=");
            if (index < 1) {
                throw new DecodeException("Broken request:" + formString);
            }
            String key = pair.substring(0, index);
            String val = index == pair.length() - 1 ? "" : pair.substring(index + 1);
            res.put(key, toMap || targetTypes[i].equals(String.class) ? val : this.converterUtil.convertIfPossible((Object)val, targetTypes[i]));
        }
        return res;
    }

    @Override
    public MediaType mediaType() {
        return MediaType.APPLICATION_FROM_URLENCODED;
    }
}

