/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12;

import java.nio.charset.StandardCharsets;

public enum HttpMethods {
    GET,
    POST,
    PUT,
    DELETE,
    HEAD,
    OPTIONS,
    PATCH,
    TRACE;

    public static final byte[][] HTTP_METHODS_BYTES;

    public static HttpMethods of(String name) {
        if (name == GET.name()) {
            return GET;
        }
        if (name == POST.name()) {
            return POST;
        }
        return HttpMethods.valueOf(name);
    }

    public static boolean isGet(String name) {
        return GET.name().equals(name);
    }

    public static boolean isPost(String name) {
        return POST.name().equals(name);
    }

    public static boolean supportBody(String name) {
        return name.charAt(0) == 'P';
    }

    static {
        HttpMethods[] methods = HttpMethods.values();
        int len = methods.length;
        HTTP_METHODS_BYTES = new byte[len][];
        for (int i = 0; i < len; ++i) {
            HttpMethods.HTTP_METHODS_BYTES[i] = methods[i].name().getBytes(StandardCharsets.ISO_8859_1);
        }
    }
}

