/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.h2;

import org.apache.dubbo.remoting.http12.AbstractServerHttpChannelObserver;
import org.apache.dubbo.remoting.http12.ErrorCodeHolder;
import org.apache.dubbo.remoting.http12.FlowControlStreamObserver;
import org.apache.dubbo.remoting.http12.HttpChannelObserver;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.h2.CancelStreamException;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2CancelableStreamObserver;
import org.apache.dubbo.remoting.http12.h2.Http2MetadataFrame;
import org.apache.dubbo.remoting.http12.message.StreamingDecoder;
import org.apache.dubbo.rpc.CancellationContext;

public class Http2ServerChannelObserver
extends AbstractServerHttpChannelObserver
implements HttpChannelObserver<Object>,
FlowControlStreamObserver<Object>,
Http2CancelableStreamObserver<Object> {
    private CancellationContext cancellationContext;
    private StreamingDecoder streamingDecoder;
    private boolean autoRequestN = true;

    public Http2ServerChannelObserver(H2StreamChannel h2StreamChannel) {
        super(h2StreamChannel);
    }

    public void setStreamingDecoder(StreamingDecoder streamingDecoder) {
        this.streamingDecoder = streamingDecoder;
    }

    @Override
    protected HttpMetadata encodeHttpMetadata() {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set(HttpHeaderNames.TE.getName(), "trailers");
        return new Http2MetadataFrame(httpHeaders);
    }

    @Override
    protected HttpMetadata encodeTrailers(Throwable throwable) {
        return new Http2MetadataFrame(new HttpHeaders(), true);
    }

    @Override
    public H2StreamChannel getHttpChannel() {
        return (H2StreamChannel)super.getHttpChannel();
    }

    @Override
    public void setCancellationContext(CancellationContext cancellationContext) {
        this.cancellationContext = cancellationContext;
    }

    @Override
    public CancellationContext getCancellationContext() {
        return this.cancellationContext;
    }

    @Override
    public void cancel(Throwable throwable) {
        if (throwable instanceof CancelStreamException && ((CancelStreamException)throwable).isCancelByRemote()) {
            this.closed();
        }
        this.cancellationContext.cancel(throwable);
        long errorCode = 0L;
        if (throwable instanceof ErrorCodeHolder) {
            errorCode = ((ErrorCodeHolder)((Object)throwable)).getErrorCode();
        }
        this.getHttpChannel().writeResetFrame(errorCode);
    }

    @Override
    public void request(int count) {
        this.streamingDecoder.request(count);
    }

    @Override
    public void disableAutoFlowControl() {
        this.autoRequestN = false;
    }

    @Override
    public boolean isAutoRequestN() {
        return this.autoRequestN;
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.streamingDecoder.onStreamClosed();
    }
}

