/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.utils.DateUtils;
import org.apache.dubbo.remoting.http12.HttpResult;
import org.apache.dubbo.remoting.http12.HttpStatus;

public class DefaultHttpResult<T>
implements HttpResult<T> {
    private int status;
    private Map<String, List<String>> headers;
    private T body;

    @Override
    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    @Override
    public T getBody() {
        return this.body;
    }

    public void setBody(T body) {
        this.body = body;
    }

    public String toString() {
        return "DefaultHttpResult{status=" + this.status + ", headers=" + this.headers + ", body=" + this.body + '}';
    }

    public static final class Builder<T> {
        private int status;
        private Map<String, List<String>> headers;
        private T body;

        public Builder<T> status(int status) {
            this.status = status;
            return this;
        }

        public Builder<T> status(HttpStatus status) {
            this.status = status.getCode();
            return this;
        }

        public Builder<T> ok() {
            return this.status(HttpStatus.OK.getCode());
        }

        public Builder<T> found(String url) {
            return this.status(HttpStatus.FOUND).header("location", url);
        }

        public Builder<T> error() {
            return this.status(HttpStatus.INTERNAL_SERVER_ERROR);
        }

        public Builder<T> headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder<T> header(String key, List<String> values) {
            this.getHeaders().put(key, values);
            return this;
        }

        public Builder<T> header(String key, String ... values) {
            this.getHeaders().put(key, Arrays.asList(values));
            return this;
        }

        public Builder<T> header(String key, String value) {
            this.getHeaders().put(key, Collections.singletonList(value));
            return this;
        }

        public Builder<T> header(String key, Date value) {
            return this.header(key, DateUtils.formatHeader((Date)value));
        }

        public Builder<T> addHeader(String key, String value) {
            this.getHeaders().computeIfAbsent(key, k -> new ArrayList()).add(value);
            return this;
        }

        private Map<String, List<String>> getHeaders() {
            Map<String, List<String>> headers = this.headers;
            if (headers == null) {
                this.headers = headers = new LinkedHashMap<String, List<String>>();
            }
            return headers;
        }

        public Builder<T> body(T body) {
            this.body = body;
            return this;
        }

        public DefaultHttpResult<T> build() {
            DefaultHttpResult<T> result = new DefaultHttpResult<T>();
            result.setStatus(this.status);
            result.setHeaders(this.headers);
            result.setBody(this.body);
            return result;
        }
    }
}

