/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message.codec;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.exception.EncodeException;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.MediaType;

public class HtmlCodec
implements HttpMessageCodec {
    @Override
    public void encode(OutputStream os, Object data, Charset charset) throws EncodeException {
        try {
            if (data instanceof CharSequence) {
                os.write(data.toString().getBytes(charset));
                return;
            }
        }
        catch (IOException e) {
            throw new EncodeException(e);
        }
        throw new EncodeException("'text/html' media-type only supports String as return type.");
    }

    @Override
    public Object decode(InputStream is, Class<?> targetType, Charset charset) throws DecodeException {
        try {
            if (targetType == String.class) {
                return StreamUtils.toString((InputStream)is, (Charset)charset);
            }
        }
        catch (HttpStatusException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DecodeException(e);
        }
        throw new DecodeException("'text/html' media-type only supports String as method param.");
    }

    @Override
    public MediaType mediaType() {
        return MediaType.TEXT_HTML;
    }
}

