/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message.codec;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.HttpMessageDecoderFactory;
import org.apache.dubbo.remoting.http12.message.HttpMessageEncoderFactory;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.remoting.http12.message.codec.YamlCodec;
import org.apache.dubbo.rpc.model.FrameworkModel;

@Activate(onClass={"org.yaml.snakeyaml.Yaml"})
public final class YamlCodecFactory
implements HttpMessageEncoderFactory,
HttpMessageDecoderFactory {
    private final YamlCodec instance = new YamlCodec();

    @Override
    public HttpMessageCodec createCodec(URL url, FrameworkModel frameworkModel, String mediaType) {
        return this.instance;
    }

    @Override
    public MediaType mediaType() {
        return MediaType.APPLICATION_YAML;
    }

    @Override
    public boolean supports(String mediaType) {
        return mediaType.startsWith(this.mediaType().getName()) || mediaType.startsWith(MediaType.TEXT_YAML.getName());
    }
}

