/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.netty4.h2;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http2.Http2StreamChannel;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.config.nested.TripleConfig;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.command.HttpWriteQueue;
import org.apache.dubbo.remoting.http12.exception.UnsupportedMediaTypeException;
import org.apache.dubbo.remoting.http12.h2.H2StreamChannel;
import org.apache.dubbo.remoting.http12.h2.Http2ServerTransportListenerFactory;
import org.apache.dubbo.remoting.http12.h2.Http2TransportListener;
import org.apache.dubbo.remoting.http12.h2.command.Http2WriteQueueChannel;
import org.apache.dubbo.remoting.http12.netty4.HttpWriteQueueHandler;
import org.apache.dubbo.remoting.http12.netty4.h2.NettyH2StreamChannel;
import org.apache.dubbo.remoting.http12.netty4.h2.NettyHttp2FrameHandler;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class NettyHttp2ProtocolSelectorHandler
extends SimpleChannelInboundHandler<HttpMetadata> {
    private final URL url;
    private final FrameworkModel frameworkModel;
    private final TripleConfig tripleConfig;
    private final Http2ServerTransportListenerFactory defaultHttp2ServerTransportListenerFactory;

    public NettyHttp2ProtocolSelectorHandler(URL url, FrameworkModel frameworkModel, TripleConfig tripleConfig, Http2ServerTransportListenerFactory defaultHttp2ServerTransportListenerFactory) {
        this.url = url;
        this.frameworkModel = frameworkModel;
        this.tripleConfig = tripleConfig;
        this.defaultHttp2ServerTransportListenerFactory = defaultHttp2ServerTransportListenerFactory;
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpMetadata metadata) {
        HttpHeaders headers = metadata.headers();
        String contentType = headers.getFirst(HttpHeaderNames.CONTENT_TYPE.getName());
        Http2ServerTransportListenerFactory factory = this.determineHttp2ServerTransportListenerFactory(contentType);
        if (factory == null) {
            throw new UnsupportedMediaTypeException(contentType);
        }
        H2StreamChannel h2StreamChannel = new NettyH2StreamChannel((Http2StreamChannel)ctx.channel(), this.tripleConfig);
        HttpWriteQueueHandler writeQueueHandler = (HttpWriteQueueHandler)ctx.channel().parent().pipeline().get(HttpWriteQueueHandler.class);
        if (writeQueueHandler != null) {
            HttpWriteQueue writeQueue = writeQueueHandler.getWriteQueue();
            h2StreamChannel = new Http2WriteQueueChannel(h2StreamChannel, writeQueue);
        }
        ChannelPipeline pipeline = ctx.pipeline();
        Http2TransportListener http2TransportListener = factory.newInstance(h2StreamChannel, this.url, this.frameworkModel);
        ctx.channel().closeFuture().addListener(future -> http2TransportListener.close());
        pipeline.addLast(new ChannelHandler[]{new NettyHttp2FrameHandler(h2StreamChannel, http2TransportListener)});
        pipeline.remove((ChannelHandler)this);
        ctx.fireChannelRead((Object)metadata);
    }

    private Http2ServerTransportListenerFactory determineHttp2ServerTransportListenerFactory(String contentType) {
        Set http2ServerTransportListenerFactories = this.frameworkModel.getExtensionLoader(Http2ServerTransportListenerFactory.class).getSupportedExtensionInstances();
        for (Http2ServerTransportListenerFactory factory : http2ServerTransportListenerFactories) {
            if (!factory.supportContentType(contentType)) continue;
            return factory;
        }
        return this.defaultHttp2ServerTransportListenerFactory;
    }
}

