/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12;

import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.remoting.http12.CustomizableHttpChannelObserver;
import org.apache.dubbo.remoting.http12.ErrorResponse;
import org.apache.dubbo.remoting.http12.ErrorResponseCustomizer;
import org.apache.dubbo.remoting.http12.ExceptionHandler;
import org.apache.dubbo.remoting.http12.HeadersCustomizer;
import org.apache.dubbo.remoting.http12.HttpChannel;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpOutputMessage;
import org.apache.dubbo.remoting.http12.HttpResult;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.TrailersCustomizer;
import org.apache.dubbo.remoting.http12.exception.EncodeException;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.remoting.http12.message.HttpMessageEncoder;

public abstract class AbstractServerHttpChannelObserver
implements CustomizableHttpChannelObserver<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractServerHttpChannelObserver.class);
    private final HttpChannel httpChannel;
    private HeadersCustomizer headersCustomizer = HeadersCustomizer.NO_OP;
    private TrailersCustomizer trailersCustomizer = TrailersCustomizer.NO_OP;
    private ErrorResponseCustomizer errorResponseCustomizer = ErrorResponseCustomizer.NO_OP;
    private ExceptionHandler<Throwable, ?> exceptionHandler;
    private HttpMessageEncoder responseEncoder;
    private String altSvc;
    private boolean headerSent;
    private boolean completed;
    private boolean closed;

    protected AbstractServerHttpChannelObserver(HttpChannel httpChannel) {
        this.httpChannel = httpChannel;
    }

    @Override
    public HttpChannel getHttpChannel() {
        return this.httpChannel;
    }

    @Override
    public void setHeadersCustomizer(HeadersCustomizer headersCustomizer) {
        this.headersCustomizer = headersCustomizer;
    }

    @Override
    public void setTrailersCustomizer(TrailersCustomizer trailersCustomizer) {
        this.trailersCustomizer = trailersCustomizer;
    }

    @Override
    public void setErrorResponseCustomizer(ErrorResponseCustomizer errorResponseCustomizer) {
        this.errorResponseCustomizer = errorResponseCustomizer;
    }

    @Override
    public void setExceptionHandler(ExceptionHandler<Throwable, ?> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setAltSvc(String altSvc) {
        this.altSvc = altSvc;
    }

    public HttpMessageEncoder getResponseEncoder() {
        return this.responseEncoder;
    }

    public void setResponseEncoder(HttpMessageEncoder responseEncoder) {
        this.responseEncoder = responseEncoder;
    }

    public final void onNext(Object data) {
        if (this.closed) {
            return;
        }
        try {
            this.doOnNext(data);
        }
        catch (Throwable e) {
            this.onError(e);
        }
    }

    protected void doOnNext(Object data) throws Throwable {
        if (!this.headerSent) {
            this.sendHeader(this.buildMetadata(this.resolveStatusCode(data), data, null));
        }
        this.sendMessage(this.buildMessage(data));
    }

    public final void onError(Throwable throwable) {
        HttpResult<?> result;
        if (this.closed) {
            return;
        }
        if (this.exceptionHandler != null && (result = this.exceptionHandler.handle(throwable)) != null) {
            this.onNext(result);
            this.onCompleted();
            return;
        }
        try {
            this.doOnError(throwable);
        }
        catch (Throwable ex) {
            throwable = new EncodeException(ex);
        }
        finally {
            this.onCompleted(throwable);
        }
    }

    protected void doOnError(Throwable throwable) throws Throwable {
        String statusCode = this.resolveStatusCode(throwable);
        ErrorResponse data = this.buildErrorResponse(statusCode, throwable);
        if (!this.headerSent) {
            this.sendHeader(this.buildMetadata(statusCode, data, null));
        }
        this.sendMessage(this.buildMessage(data));
    }

    public final void onCompleted() {
        if (this.closed) {
            return;
        }
        this.onCompleted(null);
    }

    private void onCompleted(Throwable throwable) {
        if (!this.completed) {
            this.doOnCompleted(throwable);
            this.completed = true;
        }
    }

    protected void doOnCompleted(Throwable throwable) {
        HttpMetadata httpMetadata = this.encodeTrailers(throwable);
        if (httpMetadata == null) {
            return;
        }
        if (!this.headerSent) {
            HttpHeaders headers = httpMetadata.headers();
            headers.set(HttpHeaderNames.STATUS.getName(), this.resolveStatusCode(throwable));
            headers.set(HttpHeaderNames.CONTENT_TYPE.getName(), this.responseEncoder.contentType());
        }
        this.trailersCustomizer.accept(httpMetadata.headers(), throwable);
        this.getHttpChannel().writeHeader(httpMetadata);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Http response trailers sent: " + httpMetadata.headers());
        }
    }

    protected HttpMetadata encodeTrailers(Throwable throwable) {
        return null;
    }

    protected HttpOutputMessage encodeHttpOutputMessage(Object data) {
        return this.getHttpChannel().newOutputMessage();
    }

    protected abstract HttpMetadata encodeHttpMetadata();

    protected void preOutputMessage(HttpOutputMessage outputMessage) throws Throwable {
    }

    protected void postOutputMessage(HttpOutputMessage outputMessage) throws Throwable {
    }

    protected void preMetadata(HttpMetadata httpMetadata, HttpOutputMessage outputMessage) {
    }

    protected final String resolveStatusCode(Object data) {
        return data instanceof HttpResult ? String.valueOf(((HttpResult)data).getStatus()) : HttpStatus.OK.getStatusString();
    }

    protected final String resolveStatusCode(Throwable throwable) {
        if (throwable == null) {
            return HttpStatus.OK.getStatusString();
        }
        if (throwable instanceof HttpStatusException) {
            return String.valueOf(((HttpStatusException)throwable).getStatusCode());
        }
        return HttpStatus.INTERNAL_SERVER_ERROR.getStatusString();
    }

    protected final ErrorResponse buildErrorResponse(String statusCode, Throwable throwable) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setStatus(statusCode);
        if (throwable instanceof HttpStatusException) {
            errorResponse.setMessage(((HttpStatusException)throwable).getDisplayMessage());
        } else {
            errorResponse.setMessage("Internal Server Error");
        }
        this.errorResponseCustomizer.accept(errorResponse, throwable);
        return errorResponse;
    }

    protected final HttpOutputMessage buildMessage(Object data) throws Throwable {
        HttpResult result2;
        if (data instanceof HttpResult && (data = (result2 = (HttpResult)data).getBody()) instanceof Throwable) {
            String statusCode = String.valueOf(result2.getStatus());
            data = this.buildErrorResponse(statusCode, (Throwable)data);
        }
        if (LOGGER.isDebugEnabled()) {
            try {
                LOGGER.debug("Http response body is: '{}'", new Object[]{JsonUtils.toJson((Object)data)});
            }
            catch (Throwable result2) {
                // empty catch block
            }
        }
        HttpOutputMessage outputMessage = this.encodeHttpOutputMessage(data);
        try {
            this.preOutputMessage(outputMessage);
            this.responseEncoder.encode(outputMessage.getBody(), data);
        }
        catch (Throwable t) {
            outputMessage.close();
            throw t;
        }
        return outputMessage;
    }

    protected final void sendMessage(HttpOutputMessage outputMessage) throws Throwable {
        this.getHttpChannel().writeMessage(outputMessage);
        this.postOutputMessage(outputMessage);
    }

    protected final HttpMetadata buildMetadata(String statusCode, Object data, HttpOutputMessage httpOutputMessage) {
        HttpResult result;
        HttpMetadata httpMetadata = this.encodeHttpMetadata();
        HttpHeaders headers = httpMetadata.headers();
        headers.set(HttpHeaderNames.STATUS.getName(), statusCode);
        headers.set(HttpHeaderNames.CONTENT_TYPE.getName(), this.responseEncoder.contentType());
        if (this.altSvc != null) {
            headers.set(HttpHeaderNames.ALT_SVC.getName(), this.altSvc);
        }
        if (data instanceof HttpResult && (result = (HttpResult)data).getHeaders() != null) {
            headers.putAll((Map<? extends String, ? extends List<String>>)result.getHeaders());
        }
        this.preMetadata(httpMetadata, httpOutputMessage);
        this.headersCustomizer.accept(headers);
        return httpMetadata;
    }

    protected final void sendHeader(HttpMetadata httpMetadata) {
        this.getHttpChannel().writeHeader(httpMetadata);
        this.headerSent = true;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Http response headers sent: " + httpMetadata.headers());
        }
    }

    @Override
    public void close() throws Exception {
        this.closed();
    }

    protected final void closed() {
        this.closed = true;
    }
}

