/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12;

import java.util.List;
import java.util.Map;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.message.DefaultHttpResult;

public interface HttpResult<T> {
    public int getStatus();

    public Map<String, List<String>> getHeaders();

    public T getBody();

    public static <T> DefaultHttpResult.Builder<T> builder() {
        return new DefaultHttpResult.Builder();
    }

    public static <T> HttpResult<T> of(T body) {
        return new DefaultHttpResult.Builder<T>().body(body).build();
    }

    public static <T> HttpResult<T> of(int status, T body) {
        return new DefaultHttpResult.Builder().status(status).body(body).build();
    }

    public static <T> HttpResult<T> of(HttpStatus status, T body) {
        return new DefaultHttpResult.Builder().status(status).body(body).build();
    }

    public static <T> HttpResult<T> status(int status) {
        return new DefaultHttpResult.Builder().status(status).build();
    }

    public static <T> HttpResult<T> status(HttpStatus status) {
        return new DefaultHttpResult.Builder().status(status).build();
    }

    public static <T> HttpResult<T> ok() {
        return new DefaultHttpResult.Builder().status(HttpStatus.OK).build();
    }

    public static <T> HttpResult<T> moved(String url) {
        return new DefaultHttpResult.Builder().moved(url).build();
    }

    public static <T> HttpResult<T> found(String url) {
        return new DefaultHttpResult.Builder().found(url).build();
    }

    public static <T> HttpResult<T> badRequest() {
        return new DefaultHttpResult.Builder().status(HttpStatus.BAD_REQUEST).build();
    }

    public static <T> HttpResult<T> notFound() {
        return new DefaultHttpResult.Builder().status(HttpStatus.NOT_FOUND).build();
    }

    public static HttpResult<String> error() {
        return new DefaultHttpResult.Builder().status(HttpStatus.INTERNAL_SERVER_ERROR).build();
    }

    public static HttpResult<String> error(String message) {
        return HttpResult.error(HttpStatus.INTERNAL_SERVER_ERROR, message);
    }

    public static HttpResult<String> error(int status, String message) {
        return new DefaultHttpResult.Builder().status(status).body(message).build();
    }

    public static HttpResult<String> error(HttpStatus status, String message) {
        return new DefaultHttpResult.Builder().status(status).body(message).build();
    }
}

