/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.h1;

import io.netty.buffer.ByteBufOutputStream;
import java.io.OutputStream;
import org.apache.dubbo.remoting.http12.ErrorResponse;
import org.apache.dubbo.remoting.http12.HttpChannel;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpOutputMessage;
import org.apache.dubbo.remoting.http12.h1.Http1ServerChannelObserver;

public class Http1ServerUnaryChannelObserver
extends Http1ServerChannelObserver {
    public Http1ServerUnaryChannelObserver(HttpChannel httpChannel) {
        super(httpChannel);
    }

    @Override
    protected void doOnNext(Object data) throws Throwable {
        HttpOutputMessage httpOutputMessage = this.buildMessage(data);
        this.sendHeader(this.buildMetadata(this.resolveStatusCode(data), data, httpOutputMessage));
        this.sendMessage(httpOutputMessage);
    }

    @Override
    protected void doOnError(Throwable throwable) throws Throwable {
        String statusCode = this.resolveStatusCode(throwable);
        ErrorResponse data = this.buildErrorResponse(statusCode, throwable);
        HttpOutputMessage httpOutputMessage = this.buildMessage(data);
        this.sendHeader(this.buildMetadata(statusCode, data, httpOutputMessage));
        this.sendMessage(httpOutputMessage);
    }

    @Override
    protected void preMetadata(HttpMetadata httpMetadata, HttpOutputMessage outputMessage) {
        OutputStream body = outputMessage.getBody();
        if (body instanceof ByteBufOutputStream) {
            int contentLength = ((ByteBufOutputStream)body).writtenBytes();
            httpMetadata.headers().set(HttpHeaderNames.CONTENT_LENGTH.getName(), String.valueOf(contentLength));
        }
    }
}

