/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message;

import io.netty.handler.codec.DateFormatter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpCookie;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.HttpResponse;
import org.apache.dubbo.remoting.http12.HttpResult;
import org.apache.dubbo.remoting.http12.HttpStatus;
import org.apache.dubbo.remoting.http12.HttpUtils;

public class DefaultHttpResponse
implements HttpResponse {
    private final HttpHeaders headers = new HttpHeaders();
    private int status;
    private String contentType;
    private String charset;
    private Object body;
    private OutputStream outputStream;
    private volatile boolean committed;

    @Override
    public int status() {
        return this.status;
    }

    @Override
    public void setStatus(int status) {
        if (this.committed) {
            return;
        }
        this.status = status;
    }

    @Override
    public String header(String name) {
        return this.headers.getFirst(name);
    }

    @Override
    public Date dateHeader(String name) {
        String value = this.headers.getFirst(name);
        return StringUtils.isEmpty((String)value) ? null : DateFormatter.parseHttpDate((CharSequence)value);
    }

    @Override
    public List<String> headerValues(String name) {
        return this.headers.get(name);
    }

    @Override
    public boolean hasHeader(String name) {
        return this.headers.containsKey(name);
    }

    @Override
    public Collection<String> headerNames() {
        return this.headers.keySet();
    }

    @Override
    public Map<String, List<String>> headers() {
        return Collections.unmodifiableMap(this.headers);
    }

    @Override
    public void addHeader(String name, String value) {
        if (this.committed) {
            return;
        }
        this.headers.computeIfAbsent(name, k -> new ArrayList()).add(value);
    }

    @Override
    public void addHeader(String name, Date value) {
        this.addHeader(name, DateFormatter.format((Date)value));
    }

    @Override
    public void setHeader(String name, String value) {
        if (this.committed) {
            return;
        }
        this.headers.set(name, value);
    }

    @Override
    public void setHeader(String name, Date value) {
        this.setHeader(name, DateFormatter.format((Date)value));
    }

    @Override
    public void setHeader(String name, List<String> values) {
        if (this.committed) {
            return;
        }
        this.headers.put(name, values);
    }

    @Override
    public void addCookie(HttpCookie cookie) {
        this.addHeader("set-cookie", HttpUtils.encodeCookie(cookie));
    }

    @Override
    public String contentType() {
        String contentType = this.contentType;
        if (contentType == null) {
            contentType = this.headers.getFirst(HttpHeaderNames.CONTENT_TYPE.getName());
            this.contentType = contentType = contentType == null ? "" : contentType.trim();
        }
        return contentType.isEmpty() ? null : contentType;
    }

    @Override
    public void setContentType(String contentType) {
        if (this.committed) {
            return;
        }
        this.contentType = contentType;
        this.charset = null;
    }

    @Override
    public String mediaType() {
        String contentType = this.contentType();
        if (contentType == null) {
            return null;
        }
        int index = contentType.indexOf(59);
        return index == -1 ? contentType : contentType.substring(0, index);
    }

    @Override
    public String charset() {
        String charset = this.charset;
        if (charset == null) {
            int index;
            String contentType = this.contentType();
            charset = contentType == null ? "" : ((index = contentType.lastIndexOf("charset=")) == -1 ? "" : contentType.substring(index + 8).trim());
            this.charset = charset;
        }
        return charset.isEmpty() ? null : charset;
    }

    @Override
    public void setCharset(String charset) {
        if (this.committed) {
            return;
        }
        String contentType = this.contentType();
        if (contentType != null) {
            this.contentType = contentType + "; " + "charset=" + charset;
        }
        this.charset = charset;
    }

    @Override
    public String locale() {
        return this.headers.getFirst("content-language");
    }

    @Override
    public void setLocale(String locale) {
        if (this.committed) {
            return;
        }
        this.headers.set("content-language", locale);
    }

    @Override
    public Object body() {
        return this.body;
    }

    @Override
    public void setBody(Object body) {
        if (this.committed) {
            return;
        }
        this.body = body;
    }

    @Override
    public OutputStream outputStream() {
        if (this.outputStream == null) {
            this.outputStream = new ByteArrayOutputStream(1024);
        }
        return this.outputStream;
    }

    @Override
    public void setOutputStream(OutputStream os) {
        if (this.committed) {
            return;
        }
        this.outputStream = os;
    }

    @Override
    public void sendRedirect(String location) {
        this.check();
        this.setStatus(HttpStatus.FOUND.getCode());
        this.setHeader(HttpHeaderNames.LOCATION.getName(), location);
        this.commit();
    }

    @Override
    public void sendError(int status) {
        this.check();
        this.setStatus(status);
        this.commit();
    }

    @Override
    public void sendError(int status, String message) {
        this.check();
        this.setStatus(status);
        this.setBody(message);
        this.commit();
    }

    @Override
    public boolean isEmpty() {
        if (this.status != 0) {
            return false;
        }
        if (!this.headers.isEmpty()) {
            return false;
        }
        return this.isContentEmpty();
    }

    @Override
    public boolean isContentEmpty() {
        if (this.body != null) {
            return false;
        }
        if (this.outputStream != null && this.outputStream instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)this.outputStream).size() == 0;
        }
        return true;
    }

    @Override
    public boolean isCommitted() {
        return this.committed;
    }

    @Override
    public void commit() {
        this.committed = true;
    }

    @Override
    public void setCommitted(boolean committed) {
        this.committed = committed;
    }

    @Override
    public void reset() {
        this.check();
        this.status = 0;
        this.headers.clear();
        this.contentType = null;
        this.body = null;
        this.resetBuffer();
    }

    @Override
    public void resetBuffer() {
        this.check();
        if (this.outputStream == null) {
            return;
        }
        if (this.outputStream instanceof ByteArrayOutputStream) {
            ((ByteArrayOutputStream)this.outputStream).reset();
            return;
        }
        String name = this.outputStream.getClass().getName();
        throw new UnsupportedOperationException("The outputStream type [" + name + "] is not supported to reset");
    }

    private void check() {
        if (this.committed) {
            throw new IllegalStateException("Response already committed");
        }
    }

    @Override
    public HttpResult<Object> toHttpResult() {
        int status = this.status;
        HttpHeaders headers = this.headers;
        Object body = this.body;
        if (body instanceof HttpResult) {
            Map<String, List<String>> rHeaders;
            HttpResult result = (HttpResult)body;
            if (result.getStatus() != 0) {
                status = result.getStatus();
            }
            if ((rHeaders = result.getHeaders()) != null && !rHeaders.isEmpty()) {
                headers = new HttpHeaders();
                headers.putAll(this.headers);
                for (Map.Entry<String, List<String>> entry : rHeaders.entrySet()) {
                    String key = entry.getKey();
                    if ("set-cookie".equalsIgnoreCase(key)) {
                        headers.computeIfAbsent(key, k -> new ArrayList()).addAll((Collection)entry.getValue());
                        continue;
                    }
                    headers.put(key, entry.getValue());
                }
            }
            body = result.getBody();
        }
        if (status == 0) {
            status = HttpStatus.OK.getCode();
        }
        if (body == null) {
            body = this.outputStream;
        }
        return HttpResult.builder().status(status).body(body).headers(headers).build();
    }

    public String toString() {
        return "DefaultHttpResponse{" + this.fieldToString() + '}';
    }

    protected final String fieldToString() {
        return "status=" + this.status + ", contentType='" + this.contentType() + '\'' + ", body=" + this.body;
    }
}

