/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message;

import java.io.IOException;
import java.io.InputStream;
import org.apache.dubbo.remoting.http12.CompositeInputStream;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.message.StreamingDecoder;

public class DefaultStreamingDecoder
implements StreamingDecoder {
    private boolean closed;
    protected final CompositeInputStream accumulate = new CompositeInputStream();
    protected StreamingDecoder.FragmentListener listener;

    @Override
    public void request(int numMessages) {
    }

    @Override
    public void decode(InputStream inputStream) throws DecodeException {
        if (this.closed) {
            return;
        }
        this.accumulate.addInputStream(inputStream);
    }

    @Override
    public void close() {
        try {
            if (!this.closed) {
                this.closed = true;
                this.listener.onFragmentMessage(this.accumulate);
                this.accumulate.close();
                this.listener.onClose();
            }
        }
        catch (IOException e) {
            throw new DecodeException(e);
        }
    }

    @Override
    public void onStreamClosed() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.accumulate.close();
        }
        catch (IOException e) {
            throw new DecodeException(e);
        }
    }

    @Override
    public void setFragmentListener(StreamingDecoder.FragmentListener listener) {
        this.listener = listener;
    }
}

