/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message;

import java.io.InputStream;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.message.ListeningDecoder;

public interface StreamingDecoder {
    public void request(int var1);

    public void decode(InputStream var1) throws DecodeException;

    public void close();

    public void onStreamClosed();

    public void setFragmentListener(FragmentListener var1);

    public static class DefaultFragmentListener
    implements FragmentListener {
        private final ListeningDecoder listeningDecoder;

        public DefaultFragmentListener(ListeningDecoder listeningDecoder) {
            this.listeningDecoder = listeningDecoder;
        }

        @Override
        public void onFragmentMessage(InputStream rawMessage) {
            this.listeningDecoder.decode(rawMessage);
        }

        @Override
        public void onClose() {
            this.listeningDecoder.close();
        }
    }

    public static interface FragmentListener {
        public void onFragmentMessage(InputStream var1);

        default public void onClose() {
        }
    }
}

