/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message.codec;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.dubbo.common.io.StreamUtils;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.exception.EncodeException;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.MediaType;

public class JsonCodec
implements HttpMessageCodec {
    public static final JsonCodec INSTANCE = new JsonCodec();

    @Override
    public void encode(OutputStream os, Object data, Charset charset) throws EncodeException {
        try {
            os.write(JsonUtils.toJson((Object)data).getBytes(charset));
        }
        catch (HttpStatusException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new EncodeException("Error encoding json", t);
        }
    }

    @Override
    public void encode(OutputStream os, Object[] data, Charset charset) throws EncodeException {
        try {
            os.write(JsonUtils.toJson((Object)data).getBytes(charset));
        }
        catch (HttpStatusException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new EncodeException("Error encoding json", t);
        }
    }

    @Override
    public Object decode(InputStream is, Class<?> targetType, Charset charset) throws DecodeException {
        try {
            return JsonUtils.toJavaObject((String)StreamUtils.toString((InputStream)is, (Charset)charset), targetType);
        }
        catch (HttpStatusException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new DecodeException("Error decoding json", t);
        }
    }

    @Override
    public Object decode(InputStream is, Type targetType, Charset charset) throws DecodeException {
        try {
            return JsonUtils.toJavaObject((String)StreamUtils.toString((InputStream)is, (Charset)charset), (Type)targetType);
        }
        catch (HttpStatusException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new DecodeException("Error decoding json", t);
        }
    }

    @Override
    public Object[] decode(InputStream is, Class<?>[] targetTypes, Charset charset) throws DecodeException {
        try {
            int len = targetTypes.length;
            if (len == 0) {
                return new Object[0];
            }
            Object obj = JsonUtils.toJavaObject((String)StreamUtils.toString((InputStream)is, (Charset)charset), Object.class);
            if (obj instanceof List) {
                List list = (List)obj;
                if (list.size() == len) {
                    Object[] results = new Object[len];
                    for (int i = 0; i < len; ++i) {
                        results[i] = JsonUtils.convertObject(list.get(i), targetTypes[i]);
                    }
                    return results;
                }
                throw new DecodeException("Json array size [" + list.size() + "] must equals arguments count [" + len + "]");
            }
            if (len == 1) {
                return new Object[]{JsonUtils.convertObject((Object)obj, targetTypes[0])};
            }
            throw new DecodeException("Json must be array");
        }
        catch (HttpStatusException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new DecodeException("Error decoding json", t);
        }
    }

    @Override
    public MediaType mediaType() {
        return MediaType.APPLICATION_JSON;
    }
}

