/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message.codec;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpHeaders;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.message.HttpMessageDecoder;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.apache.dubbo.remoting.http12.message.codec.CodecUtils;
import org.apache.dubbo.rpc.model.FrameworkModel;

public class MultipartDecoder
implements HttpMessageDecoder {
    private final URL url;
    private final FrameworkModel frameworkModel;
    private final String headerContentType;
    private final CodecUtils codecUtils;
    private static final String CRLF = "\r\n";

    public MultipartDecoder(URL url, FrameworkModel frameworkModel, String contentType, CodecUtils codecUtils) {
        this.url = url;
        this.frameworkModel = frameworkModel;
        this.headerContentType = contentType;
        this.codecUtils = codecUtils;
    }

    @Override
    public Object decode(InputStream inputStream, Class<?> targetType, Charset charset) throws DecodeException {
        Object[] res = this.decode(inputStream, new Class[]{targetType}, charset);
        return res.length > 1 ? res : res[0];
    }

    @Override
    public Object[] decode(InputStream inputStream, Class<?>[] targetTypes, Charset charset) throws DecodeException {
        try {
            List<Part> parts = this.transferToParts(inputStream, this.headerContentType);
            if (parts.size() != targetTypes.length) {
                throw new DecodeException("The number of method parameters and multipart request bodies are different");
            }
            Object[] res = new Object[parts.size()];
            for (int i = 0; i < parts.size(); ++i) {
                Part part = parts.get(i);
                res[i] = Byte[].class.equals(targetTypes[i]) || byte[].class.equals(targetTypes[i]) ? (Object)part.content : this.codecUtils.determineHttpMessageDecoder(this.url, this.frameworkModel, part.headers.getContentType()).decode((InputStream)new ByteArrayInputStream(part.content), targetTypes[i], charset);
            }
            return res;
        }
        catch (IOException ioException) {
            throw new DecodeException("Decode multipart body failed:" + ioException.getMessage());
        }
    }

    private List<Part> transferToParts(InputStream inputStream, String contentType) throws IOException {
        String boundary = this.getBoundaryFromContentType(contentType);
        if (StringUtils.isEmpty((String)boundary)) {
            throw new DecodeException("Invalid boundary in Content-Type: " + contentType);
        }
        String delimiter = "--" + boundary;
        ArrayList<Part> parts = new ArrayList<Part>();
        boolean endOfStream = false;
        while (!endOfStream) {
            ByteArrayOutputStream partData = new ByteArrayOutputStream();
            HttpHeaders headers = new HttpHeaders();
            endOfStream = this.readPart(inputStream, delimiter, headers, partData);
            if (partData.size() <= 0) continue;
            parts.add(new Part(partData.toByteArray(), headers));
        }
        return parts;
    }

    private String getBoundaryFromContentType(String contentType) {
        String[] parts;
        for (String part : parts = contentType.split(";")) {
            if (!(part = part.trim()).startsWith("boundary=")) continue;
            return part.substring("boundary=".length()).trim();
        }
        return null;
    }

    private boolean readPart(InputStream inputStream, String delimiter, HttpHeaders headers, ByteArrayOutputStream partData) throws IOException {
        if (this.readHeaders(inputStream, headers, delimiter)) {
            return true;
        }
        return this.readBody(inputStream, delimiter, partData);
    }

    private boolean readHeaders(InputStream inputStream, HttpHeaders httpHeaders, String delimiter) throws IOException {
        StringBuilder fullHeaderBuilder = new StringBuilder();
        String fullHeader = null;
        byte[] buffer = new byte[128];
        boolean headerEnd = false;
        boolean streamEnd = true;
        String endOfHeaderSign = "\r\n\r\n";
        byte[] delimiterBuffer = new byte[delimiter.length()];
        if (inputStream.read(delimiterBuffer) == -1) {
            return true;
        }
        String readDelimiter = new String(delimiterBuffer, StandardCharsets.US_ASCII);
        if (!Objects.equals(readDelimiter, delimiter)) {
            throw new DecodeException("Multipart body boundary are different from header");
        }
        while (!headerEnd) {
            inputStream.mark(Integer.MAX_VALUE);
            int len = inputStream.read(buffer);
            if (len == -1) break;
            String currentString = new String(buffer, 0, len, StandardCharsets.UTF_8);
            fullHeaderBuilder.append(currentString);
            int endIndex = fullHeaderBuilder.indexOf("\r\n\r\n");
            if (endIndex == -1) continue;
            inputStream.reset();
            if (inputStream.skip(endIndex + "\r\n\r\n".length()) == (long)(endIndex + "\r\n\r\n".length())) {
                streamEnd = false;
            }
            headerEnd = true;
            fullHeader = fullHeaderBuilder.substring(delimiter.length(), endIndex);
        }
        if (streamEnd && !headerEnd) {
            throw new DecodeException("Broken request: cannot found multipart body header end");
        }
        this.parseHeaderLine(httpHeaders, fullHeader.split(CRLF));
        if (httpHeaders.getContentType() == null) {
            httpHeaders.put(HttpHeaderNames.CONTENT_TYPE.getName(), Collections.singletonList("text/plain"));
        }
        return streamEnd;
    }

    private void parseHeaderLine(HttpHeaders headers, String[] headerLines) {
        for (String headerLine : headerLines) {
            int colonIndex = headerLine.indexOf(58);
            if (colonIndex == -1) continue;
            String name = headerLine.substring(0, colonIndex).trim();
            String value = headerLine.substring(colonIndex + 1).trim();
            headers.put(name, Collections.singletonList(value));
        }
    }

    private boolean readBody(InputStream inputStream, String delimiter, ByteArrayOutputStream partData) throws IOException {
        byte[] buffer = new byte[256];
        while (true) {
            inputStream.mark(Integer.MAX_VALUE);
            int len = inputStream.read(buffer);
            if (len == -1) {
                return true;
            }
            String currentString = new String(buffer, 0, len, StandardCharsets.US_ASCII);
            if (currentString.contains(delimiter)) {
                int indexOfDelimiter = currentString.indexOf(delimiter);
                byte[] toWrite = new byte[indexOfDelimiter - 2];
                System.arraycopy(buffer, 0, toWrite, 0, indexOfDelimiter - 2);
                partData.write(toWrite);
                if (currentString.length() > indexOfDelimiter + delimiter.length() + 1 && currentString.charAt(indexOfDelimiter + delimiter.length()) == '-' && currentString.charAt(indexOfDelimiter + delimiter.length() + 1) == '-') {
                    return true;
                }
                if (currentString.length() <= indexOfDelimiter + delimiter.length() + 1) {
                    byte[] endDelimiter = new byte[2];
                    if (inputStream.read(endDelimiter) != 2) {
                        throw new DecodeException("Boundary end is incomplete");
                    }
                    if (endDelimiter[0] == 45 && endDelimiter[1] == 45) {
                        return true;
                    }
                    inputStream.reset();
                    inputStream.skip(toWrite.length + 2);
                } else {
                    inputStream.reset();
                    inputStream.skip(toWrite.length + 2);
                }
                return false;
            }
            partData.write(buffer, 0, len);
        }
    }

    @Override
    public MediaType mediaType() {
        return MediaType.MULTIPART_FORM_DATA;
    }

    private static class Part {
        private final byte[] content;
        private final HttpHeaders headers;

        public Part(byte[] content, HttpHeaders headers) {
            this.content = content;
            this.headers = headers;
        }
    }
}

