/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message.codec;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.DefaultSerializeClassChecker;
import org.apache.dubbo.common.utils.JsonUtils;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.exception.EncodeException;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.representer.Representer;

public class YamlCodec
implements HttpMessageCodec {
    @Override
    public Object decode(InputStream is, Class<?> targetType, Charset charset) throws DecodeException {
        Object object;
        InputStreamReader reader = new InputStreamReader(is, charset);
        try {
            object = this.createYaml().loadAs((Reader)reader, targetType);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (HttpStatusException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new DecodeException("Error decoding yaml", t);
            }
        }
        reader.close();
        return object;
    }

    @Override
    public Object decode(InputStream is, Type targetType, Charset charset) throws DecodeException {
        Object object;
        if (targetType instanceof Class) {
            return this.decode(is, (Class)targetType, charset);
        }
        InputStreamReader reader = new InputStreamReader(is, charset);
        try {
            object = JsonUtils.convertObject((Object)this.createYaml().load((Reader)reader), (Type)targetType);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (HttpStatusException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new DecodeException("Error decoding yaml", t);
            }
        }
        reader.close();
        return object;
    }

    @Override
    public Object[] decode(InputStream is, Class<?>[] targetTypes, Charset charset) throws DecodeException {
        Object[] objectArray;
        InputStreamReader reader = new InputStreamReader(is, charset);
        try {
            Yaml yaml = this.createYaml();
            Iterator iterator = yaml.loadAll((Reader)reader).iterator();
            int len = targetTypes.length;
            Object[] results = new Object[len];
            for (int i = 0; i < len; ++i) {
                if (iterator.hasNext()) {
                    Class<?> targetType = targetTypes[i];
                    Object result = iterator.next();
                    if (targetType.isInstance(result)) {
                        results[i] = result;
                        continue;
                    }
                    results[i] = yaml.loadAs(yaml.dump(result), targetType);
                    continue;
                }
                throw new DecodeException("Not enough yaml documents in the stream");
            }
            objectArray = results;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (HttpStatusException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new DecodeException("Error decoding yaml", t);
            }
        }
        reader.close();
        return objectArray;
    }

    @Override
    public void encode(OutputStream os, Object data, Charset charset) throws EncodeException {
        try (OutputStreamWriter writer = new OutputStreamWriter(os, charset);){
            this.createYaml().dump(data, (Writer)writer);
        }
        catch (HttpStatusException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new EncodeException("Error encoding yaml", t);
        }
    }

    @Override
    public void encode(OutputStream os, Object[] data, Charset charset) throws EncodeException {
        try (OutputStreamWriter writer = new OutputStreamWriter(os, charset);){
            this.createYaml().dump((Object)data, (Writer)writer);
        }
        catch (HttpStatusException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new EncodeException("Error encoding yaml", t);
        }
    }

    @Override
    public MediaType mediaType() {
        return MediaType.APPLICATION_YAML;
    }

    private Yaml createYaml() {
        LoaderOptions options = new LoaderOptions();
        options.setAllowDuplicateKeys(false);
        DumperOptions dumperOptions = new DumperOptions();
        return new Yaml((BaseConstructor)new FilteringConstructor(options), new Representer(dumperOptions), dumperOptions, options);
    }

    private static final class FilteringConstructor
    extends Constructor {
        FilteringConstructor(LoaderOptions loaderOptions) {
            super(loaderOptions);
        }

        protected Class<?> getClassForName(String name) throws ClassNotFoundException {
            return DefaultSerializeClassChecker.getInstance().loadClass(ClassUtils.getClassLoader(), name);
        }
    }
}

