/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12;

import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.common.utils.StringUtils;

public final class HttpCookie {
    private final String name;
    private String value;
    private String domain;
    private String path;
    private long maxAge = Long.MIN_VALUE;
    private boolean secure;
    private boolean httpOnly;
    private String sameSite;

    public HttpCookie(String name, String value) {
        name = StringUtils.trim((String)name);
        Assert.notEmptyString((String)name, (String)"name is required");
        this.name = name;
        this.setValue(value);
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public void setValue(String value) {
        Assert.notNull((Object)this.name, (String)"value can not be null");
        this.value = value;
    }

    public String domain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String path() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public long maxAge() {
        return this.maxAge;
    }

    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }

    public boolean secure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean httpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public String sameSite() {
        return this.sameSite;
    }

    public void setSameSite(String sameSite) {
        this.sameSite = sameSite;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.name).append('=').append(this.value);
        if (this.domain != null) {
            buf.append(", domain=").append(this.domain);
        }
        if (this.path != null) {
            buf.append(", path=").append(this.path);
        }
        if (this.maxAge >= 0L) {
            buf.append(", maxAge=").append(this.maxAge).append('s');
        }
        if (this.secure) {
            buf.append(", secure");
        }
        if (this.httpOnly) {
            buf.append(", HTTPOnly");
        }
        if (this.sameSite != null) {
            buf.append(", SameSite=").append(this.sameSite);
        }
        return buf.toString();
    }
}

