/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.message.codec;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.dubbo.remoting.http12.exception.DecodeException;
import org.apache.dubbo.remoting.http12.exception.EncodeException;
import org.apache.dubbo.remoting.http12.exception.HttpStatusException;
import org.apache.dubbo.remoting.http12.message.HttpMessageCodec;
import org.apache.dubbo.remoting.http12.message.MediaType;
import org.xml.sax.InputSource;

public class XmlCodec
implements HttpMessageCodec {
    @Override
    public void encode(OutputStream os, Object data, Charset charset) throws EncodeException {
        try {
            Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{data.getClass()}).createMarshaller();
            try (OutputStreamWriter writer = new OutputStreamWriter(os, charset);){
                marshaller.marshal(data, (Writer)writer);
            }
        }
        catch (HttpStatusException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EncodeException("Error encoding xml", (Throwable)e);
        }
    }

    @Override
    public Object decode(InputStream is, Class<?> targetType, Charset charset) throws DecodeException {
        Object object;
        InputStreamReader reader = new InputStreamReader(is, charset);
        try {
            InputSource inputSource = new InputSource(reader);
            inputSource.setEncoding(charset.name());
            SAXSource xmlSource = new SAXSource(this.newSAXParser().getXMLReader(), inputSource);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{targetType});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            object = unmarshaller.unmarshal((Source)xmlSource);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (HttpStatusException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DecodeException("Error decoding xml", (Throwable)e);
            }
        }
        reader.close();
        return object;
    }

    private SAXParser newSAXParser() throws Exception {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        spf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        spf.setXIncludeAware(false);
        return spf.newSAXParser();
    }

    @Override
    public MediaType mediaType() {
        return MediaType.APPLICATION_XML;
    }
}

