/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.http12.netty4.h1;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.remoting.http12.HttpHeaderNames;
import org.apache.dubbo.remoting.http12.HttpMetadata;
import org.apache.dubbo.remoting.http12.HttpOutputMessage;
import org.apache.dubbo.remoting.http12.h1.DefaultHttp1Request;
import org.apache.dubbo.remoting.http12.h1.Http1InputMessage;
import org.apache.dubbo.remoting.http12.h1.Http1RequestMetadata;
import org.apache.dubbo.remoting.http12.netty4.h1.NettyHttp1HttpHeaders;

public class NettyHttp1Codec
extends ChannelDuplexHandler {
    private boolean keepAlive;

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            FullHttpRequest request = (FullHttpRequest)msg;
            this.keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
            super.channelRead(ctx, (Object)new DefaultHttp1Request(new Http1RequestMetadata(new NettyHttp1HttpHeaders(request.headers()), request.method().name(), request.uri()), new Http1InputMessage((InputStream)new ByteBufInputStream(request.content(), true))));
            return;
        }
        super.channelRead(ctx, msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpMetadata) {
            this.doWriteHeader(ctx, (HttpMetadata)msg, promise);
            return;
        }
        if (msg instanceof HttpOutputMessage) {
            this.doWriteMessage(ctx, (HttpOutputMessage)msg, promise);
            return;
        }
        super.write(ctx, msg, promise);
    }

    private void doWriteHeader(ChannelHandlerContext ctx, HttpMetadata msg, ChannelPromise promise) {
        NettyHttp1HttpHeaders headers = (NettyHttp1HttpHeaders)msg.headers();
        List<String> statusHeaders = headers.remove(HttpHeaderNames.STATUS.getKey());
        HttpResponseStatus status = HttpResponseStatus.OK;
        if (CollectionUtils.isNotEmpty(statusHeaders)) {
            status = HttpResponseStatus.valueOf((int)Integer.parseInt(statusHeaders.get(0)));
        }
        if (this.keepAlive) {
            headers.add(HttpHeaderNames.CONNECTION.getKey(), String.valueOf(HttpHeaderValues.KEEP_ALIVE));
        } else {
            headers.add(HttpHeaderNames.CONNECTION.getKey(), String.valueOf(HttpHeaderValues.CLOSE));
        }
        ctx.writeAndFlush((Object)new DefaultHttpResponse(HttpVersion.HTTP_1_1, status, (HttpHeaders)headers.getHeaders()), promise);
    }

    private void doWriteMessage(ChannelHandlerContext ctx, HttpOutputMessage msg, ChannelPromise promise) {
        if (HttpOutputMessage.EMPTY_MESSAGE == msg) {
            if (this.keepAlive) {
                ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT, promise);
            } else {
                ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT, promise).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
            return;
        }
        OutputStream body = msg.getBody();
        if (body instanceof ByteBufOutputStream) {
            ByteBuf buffer = ((ByteBufOutputStream)body).buffer();
            ctx.writeAndFlush((Object)buffer, promise);
            return;
        }
        throw new IllegalArgumentException("HttpOutputMessage body must be 'io.netty.buffer.ByteBufOutputStream'");
    }
}

