/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import io.netty.incubator.codec.quic.QuicCodecBuilder;
import io.netty.incubator.codec.quic.QuicCongestionControlAlgorithm;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.nested.TripleConfig;

final class Helper {
    Helper() {
    }

    static <T extends QuicCodecBuilder<T>> T configCodec(QuicCodecBuilder<T> builder, URL url) {
        TripleConfig tripleConfig = ConfigManager.getProtocol((URL)url).getTriple();
        if (tripleConfig.getHttp3InitialMaxData() != null) {
            builder.initialMaxData((long)tripleConfig.getHttp3InitialMaxData().intValue());
        }
        if (tripleConfig.getHttp3RecvQueueLen() != null && tripleConfig.getHttp3SendQueueLen() != null) {
            builder.datagram(tripleConfig.getHttp3RecvQueueLen().intValue(), tripleConfig.getHttp3SendQueueLen().intValue());
        }
        if (tripleConfig.getHttp3InitialMaxStreamDataBidiLocal() != null) {
            builder.initialMaxStreamDataBidirectionalLocal((long)tripleConfig.getHttp3InitialMaxStreamDataBidiLocal().intValue());
        }
        if (tripleConfig.getHttp3InitialMaxStreamDataBidiRemote() != null) {
            builder.initialMaxStreamDataBidirectionalRemote((long)tripleConfig.getHttp3InitialMaxStreamDataBidiRemote().intValue());
        }
        if (tripleConfig.getHttp3InitialMaxStreamDataUni() != null) {
            builder.initialMaxStreamDataUnidirectional((long)tripleConfig.getHttp3InitialMaxStreamDataUni().intValue());
        }
        if (tripleConfig.getHttp3InitialMaxStreamsBidi() != null) {
            builder.initialMaxStreamsBidirectional(tripleConfig.getHttp3InitialMaxStreamsBidi().longValue());
        }
        if (tripleConfig.getHttp3InitialMaxStreamsUni() != null) {
            builder.initialMaxStreamsUnidirectional(tripleConfig.getHttp3InitialMaxStreamsUni().longValue());
        }
        if (tripleConfig.getHttp3MaxAckDelayExponent() != null) {
            builder.ackDelayExponent((long)tripleConfig.getHttp3MaxAckDelayExponent().intValue());
        }
        if (tripleConfig.getHttp3MaxAckDelay() != null) {
            builder.maxAckDelay((long)tripleConfig.getHttp3MaxAckDelay().intValue(), TimeUnit.MILLISECONDS);
        }
        if (tripleConfig.getHttp3DisableActiveMigration() != null) {
            builder.activeMigration(tripleConfig.getHttp3DisableActiveMigration().booleanValue());
        }
        if (tripleConfig.getHttp3EnableHystart() != null) {
            builder.hystart(tripleConfig.getHttp3EnableHystart().booleanValue());
        }
        if (tripleConfig.getHttp3CcAlgorithm() != null) {
            if ("RENO".equalsIgnoreCase(tripleConfig.getHttp3CcAlgorithm())) {
                builder.congestionControlAlgorithm(QuicCongestionControlAlgorithm.RENO);
            } else if ("BBR".equalsIgnoreCase(tripleConfig.getHttp3CcAlgorithm())) {
                builder.congestionControlAlgorithm(QuicCongestionControlAlgorithm.BBR);
            }
        }
        return (T)builder;
    }
}

