/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.exchange;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.RemotingServer;
import org.apache.dubbo.remoting.api.connection.AbstractConnectionClient;
import org.apache.dubbo.remoting.transport.ChannelHandlerAdapter;
import org.apache.dubbo.remoting.transport.netty4.NettyHttp3ConnectionClient;
import org.apache.dubbo.remoting.transport.netty4.NettyHttp3Server;

public final class Http3Exchanger {
    private static final ErrorTypeAwareLogger LOGGER = LoggerFactory.getErrorTypeAwareLogger(Http3Exchanger.class);
    private static final Map<String, RemotingServer> SERVERS = new ConcurrentHashMap<String, RemotingServer>();
    private static final Map<String, AbstractConnectionClient> CLIENTS = new ConcurrentHashMap<String, AbstractConnectionClient>(16);
    private static final ChannelHandler HANDLER = new ChannelHandlerAdapter();

    private Http3Exchanger() {
    }

    public static RemotingServer bind(URL url) {
        return SERVERS.computeIfAbsent(url.getAddress(), addr -> {
            try {
                return new NettyHttp3Server(url, HANDLER);
            }
            catch (RemotingException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static AbstractConnectionClient connect(URL url) {
        return CLIENTS.compute(url.getAddress(), (address, client) -> {
            try {
                if (client == null) {
                    NettyHttp3ConnectionClient connectionClient = new NettyHttp3ConnectionClient(url, HANDLER);
                    connectionClient.addCloseListener(() -> Http3Exchanger.lambda$connect$1(address, (AbstractConnectionClient)connectionClient));
                    client = connectionClient;
                } else {
                    client.retain();
                }
                return client;
            }
            catch (RemotingException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static void close() {
        if (SERVERS.isEmpty()) {
            return;
        }
        ArrayList<RemotingServer> toClose = new ArrayList<RemotingServer>(SERVERS.values());
        SERVERS.clear();
        for (RemotingServer server : toClose) {
            try {
                server.close();
            }
            catch (Throwable t) {
                LOGGER.error("4-8", "", "", "Close Http3 server failed", t);
            }
        }
    }

    private static /* synthetic */ void lambda$connect$1(String address, AbstractConnectionClient connectionClient) {
        CLIENTS.remove(address, connectionClient);
    }
}

