/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import io.netty.incubator.codec.quic.QuicCodecBuilder;
import io.netty.incubator.codec.quic.QuicCongestionControlAlgorithm;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.config.context.ConfigManager;
import org.apache.dubbo.config.nested.Http3Config;
import org.apache.dubbo.config.nested.TripleConfig;

final class Helper {
    Helper() {
    }

    static <T extends QuicCodecBuilder<T>> T configCodec(QuicCodecBuilder<T> builder, URL url) {
        TripleConfig tripleConfig = ConfigManager.getProtocol((URL)url).getTriple();
        Http3Config config = tripleConfig.getHttp3();
        if (config == null) {
            config = new Http3Config();
        }
        config.checkDefault();
        builder.initialMaxData((long)config.getInitialMaxData().intValue()).initialMaxStreamDataBidirectionalLocal((long)config.getInitialMaxStreamDataBidiLocal().intValue()).initialMaxStreamDataBidirectionalRemote((long)config.getInitialMaxStreamDataBidiRemote().intValue()).initialMaxStreamDataUnidirectional((long)config.getInitialMaxStreamDataUni().intValue()).initialMaxStreamsBidirectional(config.getInitialMaxStreamsBidi().longValue()).initialMaxStreamsUnidirectional(config.getInitialMaxStreamsUni().longValue());
        if (config.getRecvQueueLen() != null && config.getSendQueueLen() != null) {
            builder.datagram(config.getRecvQueueLen().intValue(), config.getSendQueueLen().intValue());
        }
        if (config.getMaxAckDelayExponent() != null) {
            builder.ackDelayExponent((long)config.getMaxAckDelayExponent().intValue());
        }
        if (config.getMaxAckDelay() != null) {
            builder.maxAckDelay((long)config.getMaxAckDelay().intValue(), TimeUnit.MILLISECONDS);
        }
        if (config.getDisableActiveMigration() != null) {
            builder.activeMigration(config.getDisableActiveMigration().booleanValue());
        }
        if (config.getEnableHystart() != null) {
            builder.hystart(config.getEnableHystart().booleanValue());
        }
        if (config.getCcAlgorithm() != null) {
            if ("RENO".equalsIgnoreCase(config.getCcAlgorithm())) {
                builder.congestionControlAlgorithm(QuicCongestionControlAlgorithm.RENO);
            } else if ("BBR".equalsIgnoreCase(config.getCcAlgorithm())) {
                builder.congestionControlAlgorithm(QuicCongestionControlAlgorithm.BBR);
            }
        }
        return (T)builder;
    }
}

