/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.transport.netty4;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.incubator.codec.http3.Http3;
import io.netty.incubator.codec.http3.Http3ClientConnectionHandler;
import io.netty.incubator.codec.quic.QuicChannel;
import io.netty.incubator.codec.quic.QuicChannelBootstrap;
import io.netty.incubator.codec.quic.QuicClientCodecBuilder;
import io.netty.incubator.codec.quic.QuicSslContext;
import io.netty.incubator.codec.quic.QuicSslContextBuilder;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.transport.netty4.AbstractNettyConnectionClient;
import org.apache.dubbo.remoting.transport.netty4.Helper;
import org.apache.dubbo.remoting.transport.netty4.NettyConnectionHandler;
import org.apache.dubbo.remoting.transport.netty4.NettyEventLoopFactory;
import org.apache.dubbo.remoting.utils.UrlUtils;

public final class NettyHttp3ConnectionClient
extends AbstractNettyConnectionClient {
    private AtomicReference<Channel> datagramChannel;
    private QuicChannelBootstrap bootstrap;

    public NettyHttp3ConnectionClient(URL url, ChannelHandler handler) throws RemotingException {
        super(url, handler);
    }

    protected void initConnectionClient() {
        super.initConnectionClient();
        this.datagramChannel = new AtomicReference();
    }

    protected void initBootstrap() throws Exception {
        QuicSslContext context = QuicSslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).applicationProtocols(Http3.supportedApplicationProtocols()).build();
        int idleTimeout = UrlUtils.getIdleTimeout((URL)this.getUrl());
        final io.netty.channel.ChannelHandler codec = ((QuicClientCodecBuilder)((QuicClientCodecBuilder)((QuicClientCodecBuilder)Helper.configCodec(Http3.newQuicClientCodecBuilder(), this.getUrl())).maxIdleTimeout((long)idleTimeout, TimeUnit.MILLISECONDS)).sslContext(context)).build();
        Channel nettyDatagramChannel = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.getConnectTimeout())).group((EventLoopGroup)NettyEventLoopFactory.NIO_EVENT_LOOP_GROUP.get())).channel(NioDatagramChannel.class)).handler((io.netty.channel.ChannelHandler)new ChannelInitializer<NioDatagramChannel>(){

            protected void initChannel(NioDatagramChannel ch) {
                ch.pipeline().addLast(new io.netty.channel.ChannelHandler[]{codec});
            }
        })).bind(0).sync().channel();
        this.datagramChannel.set(nettyDatagramChannel);
        nettyDatagramChannel.closeFuture().addListener(channelFuture -> this.datagramChannel.set(null));
        final int heartbeat = UrlUtils.getHeartbeat((URL)this.getUrl());
        final NettyConnectionHandler connectionHandler = new NettyConnectionHandler((AbstractNettyConnectionClient)this);
        this.bootstrap = QuicChannel.newBootstrap((Channel)nettyDatagramChannel).handler((io.netty.channel.ChannelHandler)new ChannelInitializer<QuicChannel>(){

            protected void initChannel(QuicChannel ch) {
                ch.pipeline().addLast(new io.netty.channel.ChannelHandler[]{new IdleStateHandler((long)heartbeat, 0L, 0L, TimeUnit.MILLISECONDS)}).addLast("connectionHandler", (io.netty.channel.ChannelHandler)connectionHandler).addLast(new io.netty.channel.ChannelHandler[]{new Http3ClientConnectionHandler()});
                ch.closeFuture().addListener(channelFuture -> NettyHttp3ConnectionClient.this.clearNettyChannel());
            }
        }).remoteAddress((SocketAddress)this.getConnectAddress());
    }

    protected ChannelFuture performConnect() {
        Channel channel = this.getNettyDatagramChannel();
        if (channel == null) {
            return null;
        }
        ChannelPromise promise = channel.newPromise();
        GenericFutureListener listener = f -> {
            if (f.isSuccess()) {
                promise.setSuccess(null);
            } else {
                promise.setFailure(f.cause());
            }
        };
        this.bootstrap.connect().addListener(listener);
        return promise;
    }

    protected void performClose() {
        super.performClose();
        Channel current = this.getNettyDatagramChannel();
        if (current != null) {
            current.close();
        }
        this.datagramChannel.set(null);
    }

    private Channel getNettyDatagramChannel() {
        return this.datagramChannel.get();
    }
}

